/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.directory;

import java.io.EOFException;
import java.io.IOException;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.SeekableInputStream;
import org.apache.lucene.store.IndexInput;

class FileIndexInput
extends IndexInput {
    private final File file;
    SeekableInputStream in;
    private long position;
    private final long sliceOffset;
    private final long sliceLength;

    FileIndexInput(String resourceDesc, File file) {
        this(resourceDesc, file, 0L, file.getLength());
    }

    private FileIndexInput(String resourceDesc, File file, long offset, long length) {
        super(resourceDesc);
        this.file = file;
        this.in = file.getInputStream();
        this.sliceOffset = offset;
        this.sliceLength = length;
    }

    public long length() {
        return this.sliceLength;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public FileIndexInput clone() {
        FileIndexInput clone = (FileIndexInput)super.clone();
        clone.in = this.in.clone();
        return clone;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        this.in.seek(pos + this.sliceOffset);
        this.position = pos;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (length > this.sliceLength - offset) {
            throw new IllegalArgumentException("Slice length is to large. Asked for " + length + " file length is " + this.sliceLength + ": " + this.file.getName());
        }
        if (offset < 0L || offset >= this.sliceLength) {
            throw new IllegalArgumentException("Slice offset is invalid: " + this.file.getName());
        }
        FileIndexInput result = new FileIndexInput(sliceDescription, this.file, this.sliceOffset + offset, length);
        result.seek(0L);
        return result;
    }

    public byte readByte() throws IOException {
        if (++this.position > this.sliceLength) {
            throw new EOFException("Read past end of file " + this.file.getName());
        }
        int result = this.in.read();
        if (result == -1) {
            throw new EOFException("Read past end of file " + this.file.getName());
        }
        return (byte)result;
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.position + (long)len > this.sliceLength) {
            throw new EOFException("Read past end of file " + this.file.getName());
        }
        int numRead = this.in.read(b, offset, len);
        if (numRead < len) {
            throw new EOFException("Read past end of file " + this.file.getName());
        }
        this.position += (long)len;
    }
}

