/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.commands;

import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.commands.LuceneCommandBase;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

public class LuceneDescribeIndexCommand
extends LuceneCommandBase {
    @ShellMethod(value="Display the description of lucene indexes created for all members.", key={"describe lucene index"})
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel describeIndex(@ShellOption(value={"name"}, help="Name of the lucene index to describe.") String indexName, @ShellOption(value={"region"}, help="Name/Path of the region defining the lucene index to be described.") String regionPath) throws Exception {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "LUCENE");
        LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
        return this.toTabularResult(this.getIndexDetails(indexInfo), true);
    }

    @Override
    @ShellMethodAvailability(value={"describe lucene index"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

