/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntSupplier;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexResultCollector;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.LockNotHeldException;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;

public class IndexRepositoryImpl
implements IndexRepository {
    private static final boolean APPLY_ALL_DELETES = System.getProperty("gemfire.IndexRepository.APPLY_ALL_DELETES", "true").equalsIgnoreCase("true");
    private final IndexWriter writer;
    private final LuceneSerializer serializer;
    private final SearcherManager searcherManager;
    private Region<?, ?> region;
    private Region<?, ?> userRegion;
    private LuceneIndexStats stats;
    private DocumentCountSupplier documentCountSupplier;
    private final DistributedLockService lockService;
    private String lockName;
    private LuceneIndex index;
    private static final Logger logger = LogService.getLogger();

    public IndexRepositoryImpl(Region<?, ?> region, IndexWriter writer, LuceneSerializer serializer, LuceneIndexStats stats, Region<?, ?> userRegion, DistributedLockService lockService, String lockName, LuceneIndex index) throws IOException {
        this.region = region;
        this.userRegion = userRegion;
        this.writer = writer;
        this.searcherManager = this.createSearchManager();
        this.serializer = serializer;
        this.stats = stats;
        this.documentCountSupplier = new DocumentCountSupplier();
        stats.addDocumentsSupplier(this.documentCountSupplier);
        this.lockService = lockService;
        this.lockName = lockName;
        this.index = index;
    }

    protected SearcherManager createSearchManager() throws IOException {
        return new SearcherManager(this.writer, APPLY_ALL_DELETES, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Object key, Object value) throws IOException {
        long start = this.stats.startUpdate();
        Collection<Object> docs = Collections.emptyList();
        boolean exceptionHappened = false;
        try {
            try {
                docs = this.serializer.toDocuments(this.index, value);
            }
            catch (Exception e) {
                exceptionHappened = true;
                this.stats.incFailedEntries();
                logger.info("Failed to add index for " + value + " due to " + e.getMessage());
            }
            if (!exceptionHappened) {
                docs.forEach(doc -> SerializerUtil.addKey(key, doc));
                this.writer.addDocuments(docs);
            }
        }
        finally {
            this.stats.endUpdate(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Object key, Object value) throws IOException {
        long start = this.stats.startUpdate();
        Collection<Object> docs = Collections.emptyList();
        boolean exceptionHappened = false;
        try {
            try {
                docs = this.serializer.toDocuments(this.index, value);
            }
            catch (Exception e) {
                exceptionHappened = true;
                this.stats.incFailedEntries();
                logger.info("Failed to update index for " + value + " due to " + e.getMessage());
            }
            if (!exceptionHappened) {
                docs.forEach(doc -> SerializerUtil.addKey(key, doc));
                Term keyTerm = SerializerUtil.toKeyTerm(key);
                this.writer.updateDocuments(keyTerm, docs);
            }
        }
        finally {
            this.stats.endUpdate(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Object key) throws IOException {
        long start = this.stats.startUpdate();
        try {
            Term keyTerm = SerializerUtil.toKeyTerm(key);
            this.writer.deleteDocuments(new Term[]{keyTerm});
        }
        finally {
            this.stats.endUpdate(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Query query, int limit, IndexResultCollector collector) throws IOException {
        long start = this.stats.startRepositoryQuery();
        int totalHits = 0;
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs docs = searcher.search(query, limit);
            totalHits = docs.totalHits;
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                Document doc = searcher.doc(scoreDoc.doc);
                Object key = SerializerUtil.getKey(doc);
                if (logger.isDebugEnabled()) {
                    logger.debug("query found doc:" + doc + ":" + scoreDoc);
                }
                collector.collect(key, scoreDoc.score);
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
            this.stats.endRepositoryQuery(start, totalHits);
        }
    }

    @Override
    public synchronized void commit() throws IOException {
        long start = this.stats.startCommit();
        try {
            this.writer.commit();
            this.searcherManager.maybeRefresh();
        }
        finally {
            this.stats.endCommit(start);
        }
    }

    @Override
    public IndexWriter getWriter() {
        return this.writer;
    }

    @Override
    public Region<?, ?> getRegion() {
        return this.region;
    }

    public LuceneSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isClosed() {
        return this.userRegion.isDestroyed() || !this.writer.isOpen();
    }

    @Override
    public void cleanup() {
        try {
            this.stats.removeDocumentsSupplier(this.documentCountSupplier);
            try {
                this.writer.close();
            }
            catch (Exception e) {
                logger.debug("Unable to clean up index repository", (Throwable)e);
            }
        }
        finally {
            try {
                if (this.lockService != null) {
                    this.lockService.unlock((Object)this.lockName);
                }
            }
            catch (LockNotHeldException e) {
                logger.debug("Tried to unlock file region lock(" + this.lockName + ") that we did not hold", (Throwable)e);
            }
        }
    }

    private class DocumentCountSupplier
    implements IntSupplier {
        private DocumentCountSupplier() {
        }

        @Override
        public int getAsInt() {
            if (IndexRepositoryImpl.this.isClosed() || !((BucketRegion)IndexRepositoryImpl.this.userRegion).getBucketAdvisor().isPrimary()) {
                IndexRepositoryImpl.this.stats.removeDocumentsSupplier(this);
                return 0;
            }
            try {
                return IndexRepositoryImpl.this.writer.numDocs();
            }
            catch (AlreadyClosedException e) {
                return 0;
            }
        }
    }
}

