/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import org.apache.geode.cache.lucene.internal.AbstractPartitionedRepositoryManager;
import org.apache.geode.cache.partition.PartitionListenerAdapter;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;

public class LuceneBucketListener
extends PartitionListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private AbstractPartitionedRepositoryManager lucenePartitionRepositoryManager;
    private final DistributionManager dm;

    public LuceneBucketListener(AbstractPartitionedRepositoryManager partitionedRepositoryManager, DistributionManager dm) {
        this.lucenePartitionRepositoryManager = partitionedRepositoryManager;
        this.dm = dm;
    }

    public void afterPrimary(int bucketId) {
        this.dm.getWaitingThreadPool().execute(() -> {
            try {
                this.lucenePartitionRepositoryManager.computeRepository(bucketId);
            }
            catch (PrimaryBucketException e) {
                logger.info("Index repository could not be created because we are no longer primary?", (Throwable)e);
            }
        });
    }

    public void afterBucketRemoved(int bucketId, Iterable<?> keys) {
        this.afterSecondary(bucketId);
    }

    public void afterSecondary(int bucketId) {
        this.dm.getWaitingThreadPool().execute(() -> {
            try {
                this.lucenePartitionRepositoryManager.computeRepository(bucketId);
            }
            catch (PrimaryBucketException | AlreadyClosedException e) {
                logger.debug("Exception while cleaning up Lucene Index Repository", e);
            }
        });
    }
}

