/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneIndexExistsException;
import org.apache.geode.cache.lucene.LuceneIndexFactory;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.internal.DestroyLuceneIndexMessage;
import org.apache.geode.cache.lucene.internal.IndexListener;
import org.apache.geode.cache.lucene.internal.InternalLuceneService;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexFactoryImpl;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneIndexImplFactory;
import org.apache.geode.cache.lucene.internal.LuceneQueryFactoryImpl;
import org.apache.geode.cache.lucene.internal.LuceneRegionListener;
import org.apache.geode.cache.lucene.internal.LuceneResultStructImpl;
import org.apache.geode.cache.lucene.internal.StringQueryProvider;
import org.apache.geode.cache.lucene.internal.directory.DumpDirectoryFiles;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.LuceneQueryFunction;
import org.apache.geode.cache.lucene.internal.distributed.TopEntries;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.cache.lucene.internal.distributed.WaitUntilFlushedFunction;
import org.apache.geode.cache.lucene.internal.distributed.WaitUntilFlushedFunctionContext;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.management.LuceneServiceMBean;
import org.apache.geode.cache.lucene.internal.management.ManagementIndexListener;
import org.apache.geode.cache.lucene.internal.results.LuceneGetPageFunction;
import org.apache.geode.cache.lucene.internal.results.PageResults;
import org.apache.geode.cache.lucene.internal.xml.LuceneServiceXmlGenerator;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneServiceImpl
implements InternalLuceneService {
    public static LuceneIndexImplFactory luceneIndexFactory = new LuceneIndexImplFactory();
    private static final Logger logger = LogService.getLogger();
    private InternalCache cache;
    private final HashMap<String, LuceneIndex> indexMap = new HashMap();
    private final HashMap<String, LuceneIndexCreationProfile> definedIndexMap = new HashMap();
    private IndexListener managementListener;

    @Override
    public LuceneIndexFactory createIndexFactory() {
        return new LuceneIndexFactoryImpl(this);
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    public void init(Cache cache) {
        if (cache == null) {
            throw new IllegalStateException(LocalizedStrings.CqService_CACHE_IS_NULL.toLocalizedString());
        }
        cache.getCancelCriterion().checkCancelInProgress(null);
        this.cache = (InternalCache)cache;
        FunctionService.registerFunction((Function)new LuceneQueryFunction());
        FunctionService.registerFunction((Function)new LuceneGetPageFunction());
        FunctionService.registerFunction((Function)new WaitUntilFlushedFunction());
        FunctionService.registerFunction((Function)new DumpDirectoryFiles());
        LuceneServiceImpl.registerDataSerializables();
    }

    public CacheServiceMBeanBase getMBean() {
        LuceneServiceMBean mbean = new LuceneServiceMBean(this);
        this.managementListener = new ManagementIndexListener(mbean);
        return mbean;
    }

    public Class<? extends CacheService> getInterface() {
        return InternalLuceneService.class;
    }

    public void beforeRegionDestroyed(Region region) {
        List<LuceneIndex> indexes = this.getIndexes(region.getFullPath());
        if (!indexes.isEmpty()) {
            String indexNames = indexes.stream().map(i -> i.getName()).collect(Collectors.joining(","));
            throw new IllegalStateException(LocalizedStrings.LuceneServiceImpl_REGION_0_CANNOT_BE_DESTROYED.toLocalizedString(new Object[]{region.getFullPath(), indexNames}));
        }
    }

    public static String getUniqueIndexName(String indexName, String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        String name = indexName + "#" + regionPath.replace('/', '_');
        return name;
    }

    public static String getUniqueIndexRegionName(String indexName, String regionPath, String regionSuffix) {
        return LuceneServiceImpl.getUniqueIndexName(indexName, regionPath) + regionSuffix;
    }

    public void createIndex(String indexName, String regionPath, Map<String, Analyzer> fieldAnalyzers) {
        if (fieldAnalyzers == null || fieldAnalyzers.isEmpty()) {
            throw new IllegalArgumentException("At least one field must be indexed");
        }
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), fieldAnalyzers);
        Set<String> fieldsSet = fieldAnalyzers.keySet();
        String[] fields = fieldsSet.toArray(new String[fieldsSet.size()]);
        this.createIndex(indexName, regionPath, (Analyzer)analyzer, fieldAnalyzers, fields);
    }

    public void createIndex(String indexName, String regionPath, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers, String ... fields) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        this.registerDefinedIndex(indexName, regionPath, new LuceneIndexCreationProfile(indexName, regionPath, fields, analyzer, fieldAnalyzers));
        Region region = this.cache.getRegion(regionPath);
        if (region != null) {
            this.definedIndexMap.remove(LuceneServiceImpl.getUniqueIndexName(indexName, regionPath));
            throw new IllegalStateException("The lucene index must be created before region");
        }
        this.cache.addRegionListener((RegionListener)new LuceneRegionListener(this, this.cache, indexName, regionPath, fields, analyzer, fieldAnalyzers));
    }

    public void afterDataRegionCreated(LuceneIndexImpl index) {
        index.initialize();
        this.registerIndex(index);
        if (this.managementListener != null) {
            this.managementListener.afterIndexCreated(index);
        }
    }

    public LuceneIndexImpl beforeDataRegionCreated(String indexName, String regionPath, RegionAttributes attributes, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers, String aeqId, String ... fields) {
        LuceneIndexImpl index = this.createIndexObject(indexName, regionPath);
        index.setSearchableFields(fields);
        index.setAnalyzer(analyzer);
        index.setFieldAnalyzers(fieldAnalyzers);
        index.setupRepositoryManager();
        index.setupAEQ(attributes, aeqId);
        return index;
    }

    private LuceneIndexImpl createIndexObject(String indexName, String regionPath) {
        return luceneIndexFactory.create(indexName, regionPath, this.cache);
    }

    private void registerDefinedIndex(String indexName, String regionPath, LuceneIndexCreationProfile luceneIndexCreationProfile) {
        String regionAndIndex = LuceneServiceImpl.getUniqueIndexName(indexName, regionPath);
        if (this.definedIndexMap.containsKey(regionAndIndex) || this.indexMap.containsKey(regionAndIndex)) {
            throw new LuceneIndexExistsException(indexName, regionPath);
        }
        this.definedIndexMap.put(regionAndIndex, luceneIndexCreationProfile);
    }

    @Override
    public LuceneIndex getIndex(String indexName, String regionPath) {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        return this.indexMap.get(LuceneServiceImpl.getUniqueIndexName(indexName, region.getFullPath()));
    }

    @Override
    public Collection<LuceneIndex> getAllIndexes() {
        return this.indexMap.values();
    }

    public List<LuceneIndex> getIndexes(String regionPath) {
        ArrayList<LuceneIndex> indexes = new ArrayList<LuceneIndex>();
        for (LuceneIndex index : this.getAllIndexes()) {
            if (!index.getRegionPath().equals(regionPath)) continue;
            indexes.add(index);
        }
        return Collections.unmodifiableList(indexes);
    }

    @Override
    public void destroyIndex(String indexName, String regionPath) {
        this.destroyIndex(indexName, regionPath, true);
    }

    protected void destroyIndex(String indexName, String regionPath, boolean initiator) {
        LuceneIndexImpl indexImpl;
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        if ((indexImpl = (LuceneIndexImpl)this.getIndex(indexName, regionPath)) == null) {
            this.destroyDefinedIndex(indexName, regionPath);
        } else {
            indexImpl.destroy(initiator);
            this.removeFromIndexMap(indexImpl);
            logger.info(LocalizedStrings.LuceneService_DESTROYED_INDEX_0_FROM_1_REGION_2.toLocalizedString(new Object[]{indexName, "initialized", regionPath}));
        }
    }

    public void destroyDefinedIndex(String indexName, String regionPath) {
        String uniqueIndexName;
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        if (this.definedIndexMap.containsKey(uniqueIndexName = LuceneServiceImpl.getUniqueIndexName(indexName, regionPath))) {
            this.definedIndexMap.remove(uniqueIndexName);
            LuceneRegionListener listenerToRemove = null;
            for (RegionListener listener : this.cache.getRegionListeners()) {
                LuceneRegionListener lrl;
                if (!(listener instanceof LuceneRegionListener) || !(lrl = (LuceneRegionListener)listener).getRegionPath().equals(regionPath) || !lrl.getIndexName().equals(indexName)) continue;
                listenerToRemove = lrl;
                break;
            }
            if (listenerToRemove != null) {
                this.cache.removeRegionListener(listenerToRemove);
            }
        } else {
            throw new IllegalArgumentException(LocalizedStrings.LuceneService_INDEX_0_NOT_FOUND_IN_REGION_1.toLocalizedString(new Object[]{indexName, regionPath}));
        }
        logger.info(LocalizedStrings.LuceneService_DESTROYED_INDEX_0_FROM_1_REGION_2.toLocalizedString(new Object[]{indexName, "defined", regionPath}));
    }

    @Override
    public void destroyIndexes(String regionPath) {
        this.destroyIndexes(regionPath, true);
    }

    protected void destroyIndexes(String regionPath, boolean initiator) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        ArrayList<LuceneIndexImpl> indexesToDestroy = new ArrayList<LuceneIndexImpl>();
        for (LuceneIndex luceneIndex : this.getAllIndexes()) {
            if (!luceneIndex.getRegionPath().equals(regionPath)) continue;
            LuceneIndexImpl indexImpl = (LuceneIndexImpl)luceneIndex;
            indexImpl.destroy(initiator);
            indexesToDestroy.add(indexImpl);
        }
        if (indexesToDestroy.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.LuceneService_NO_INDEXES_WERE_FOUND_IN_REGION_0.toLocalizedString(new Object[]{regionPath}));
        }
        for (LuceneIndex luceneIndex : indexesToDestroy) {
            this.removeFromIndexMap(luceneIndex);
            logger.info(LocalizedStrings.LuceneService_DESTROYED_INDEX_0_FROM_1_REGION_2.toLocalizedString(new Object[]{luceneIndex.getName(), "initialized", regionPath}));
        }
    }

    public void destroyDefinedIndexes(String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        ArrayList<LuceneIndexCreationProfile> indexesToDestroy = new ArrayList<LuceneIndexCreationProfile>();
        for (Map.Entry<String, LuceneIndexCreationProfile> entry : this.definedIndexMap.entrySet()) {
            if (!entry.getValue().getRegionPath().equals(regionPath)) continue;
            indexesToDestroy.add(entry.getValue());
        }
        if (indexesToDestroy.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.LuceneService_NO_INDEXES_WERE_FOUND_IN_REGION_0.toLocalizedString(new Object[]{regionPath}));
        }
        for (LuceneIndexCreationProfile profile : indexesToDestroy) {
            this.destroyDefinedIndex(profile.getIndexName(), profile.getRegionPath());
        }
    }

    private void removeFromIndexMap(LuceneIndex index) {
        this.indexMap.remove(LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath()));
    }

    @Override
    public LuceneQueryFactory createLuceneQueryFactory() {
        return new LuceneQueryFactoryImpl((Cache)this.cache);
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return new LuceneServiceXmlGenerator();
    }

    public void beforeCreate(Extensible<Cache> source, Cache cache) {
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
    }

    public void registerIndex(LuceneIndex index) {
        String regionAndIndex = LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath());
        if (!this.indexMap.containsKey(regionAndIndex)) {
            this.indexMap.put(regionAndIndex, index);
        }
        this.definedIndexMap.remove(regionAndIndex);
    }

    public void unregisterIndex(String region) {
        if (this.indexMap.containsKey(region)) {
            this.indexMap.remove(region);
        }
    }

    public static void registerDataSerializables() {
        DSFIDFactory.registerDSFID((int)2169, ChunkKey.class);
        DSFIDFactory.registerDSFID((int)2170, File.class);
        DSFIDFactory.registerDSFID((int)2171, LuceneFunctionContext.class);
        DSFIDFactory.registerDSFID((int)2172, StringQueryProvider.class);
        DSFIDFactory.registerDSFID((int)2173, TopEntriesCollectorManager.class);
        DSFIDFactory.registerDSFID((int)2174, EntryScore.class);
        DSFIDFactory.registerDSFID((int)2175, TopEntries.class);
        DSFIDFactory.registerDSFID((int)2176, TopEntriesCollector.class);
        DSFIDFactory.registerDSFID((int)2177, WaitUntilFlushedFunctionContext.class);
        DSFIDFactory.registerDSFID((int)2178, DestroyLuceneIndexMessage.class);
        DSFIDFactory.registerDSFID((int)2179, PageResults.class);
        DSFIDFactory.registerDSFID((int)2180, LuceneResultStructImpl.class);
    }

    public Collection<LuceneIndexCreationProfile> getAllDefinedIndexes() {
        return this.definedIndexMap.values();
    }

    public LuceneIndexCreationProfile getDefinedIndex(String indexName, String regionPath) {
        return this.definedIndexMap.get(LuceneServiceImpl.getUniqueIndexName(indexName, regionPath));
    }

    @Override
    public boolean waitUntilFlushed(String indexName, String regionPath, long timeout, TimeUnit unit) throws InterruptedException {
        Region dataRegion = this.cache.getRegion(regionPath);
        if (dataRegion == null) {
            logger.info("Data region " + regionPath + " not found");
            return false;
        }
        WaitUntilFlushedFunctionContext context = new WaitUntilFlushedFunctionContext(indexName, timeout, unit);
        Execution execution = FunctionService.onRegion((Region)dataRegion);
        ResultCollector rs = execution.setArguments((Object)context).execute(WaitUntilFlushedFunction.ID);
        List results = (List)rs.getResult();
        for (Boolean oneResult : results) {
            if (oneResult.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static enum validateCommandParameters {
        REGION_PATH,
        INDEX_NAME;


        public void validateName(String name) {
            if (name == null) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_NULL.toLocalizedString());
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_EMPTY.toLocalizedString());
            }
            boolean iae = false;
            String msg = " names may only be alphanumeric, must not begin with double-underscores, but can contain hyphens";
            Matcher matcher = null;
            switch (this) {
                case REGION_PATH: {
                    matcher = Pattern.compile("[aA-zZ0-9-_./]+").matcher(name);
                    msg = "Region" + msg + ", underscores, or forward slashes: ";
                    iae = name.startsWith("__") || !matcher.matches();
                    break;
                }
                case INDEX_NAME: {
                    matcher = Pattern.compile("[aA-zZ0-9-_.]+").matcher(name);
                    msg = "Index" + msg + " or underscores: ";
                    iae = name.startsWith("__") || !matcher.matches();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal option for validateName function");
                }
            }
            if (iae) {
                throw new IllegalArgumentException(msg + name);
            }
        }
    }
}

