/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.lucene.internal.AbstractPartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneEventListener;
import org.apache.geode.cache.lucene.internal.LuceneEventSubstitutionFilter;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexCreation;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public abstract class LuceneIndexImpl
implements InternalLuceneIndex {
    protected static final Logger logger = LogService.getLogger();
    protected final String indexName;
    protected final String regionPath;
    protected final InternalCache cache;
    protected final LuceneIndexStats indexStats;
    protected boolean hasInitialized = false;
    protected boolean hasInitializedAEQ = false;
    protected Map<String, Analyzer> fieldAnalyzers;
    protected String[] searchableFieldNames;
    protected RepositoryManager repositoryManager;
    protected Analyzer analyzer;
    protected LocalRegion dataRegion;

    protected LuceneIndexImpl(String indexName, String regionPath, InternalCache cache) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.cache = cache;
        String statsName = indexName + "-" + regionPath;
        this.indexStats = new LuceneIndexStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    protected LocalRegion getDataRegion() {
        return (LocalRegion)this.cache.getRegion(this.regionPath);
    }

    protected boolean withPersistence() {
        RegionAttributes ra = this.dataRegion.getAttributes();
        DataPolicy dp = ra.getDataPolicy();
        boolean withPersistence = dp.withPersistence();
        return withPersistence;
    }

    protected void setSearchableFields(String[] fields) {
        this.searchableFieldNames = fields;
    }

    @Override
    public String[] getFieldNames() {
        return this.searchableFieldNames;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers == null ? null : Collections.unmodifiableMap(fieldAnalyzers);
    }

    public LuceneIndexStats getIndexStats() {
        return this.indexStats;
    }

    protected void initialize() {
        if (!this.hasInitialized) {
            this.dataRegion = this.getDataRegion();
            this.createLuceneListenersAndFileChunkRegions((AbstractPartitionedRepositoryManager)this.repositoryManager);
            this.addExtension(this.dataRegion);
            this.hasInitialized = true;
        }
    }

    protected void setupAEQ(RegionAttributes attributes, String aeqId) {
        if (!this.hasInitializedAEQ) {
            this.createAEQ(attributes, aeqId);
            this.hasInitializedAEQ = true;
        }
    }

    protected void setupRepositoryManager() {
        this.repositoryManager = this.createRepositoryManager();
    }

    protected abstract RepositoryManager createRepositoryManager();

    protected abstract void createLuceneListenersAndFileChunkRegions(AbstractPartitionedRepositoryManager var1);

    protected AsyncEventQueue createAEQ(Region dataRegion) {
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.regionPath);
        return this.createAEQ(this.createAEQFactory(dataRegion.getAttributes()), aeqId);
    }

    protected AsyncEventQueue createAEQ(RegionAttributes attributes, String aeqId) {
        return this.createAEQ(this.createAEQFactory(attributes), aeqId);
    }

    private AsyncEventQueueFactoryImpl createAEQFactory(RegionAttributes attributes) {
        AsyncEventQueueFactoryImpl factory = (AsyncEventQueueFactoryImpl)this.cache.createAsyncEventQueueFactory();
        if (attributes.getPartitionAttributes() != null) {
            if (attributes.getPartitionAttributes().getLocalMaxMemory() == 0) {
                return null;
            }
            factory.setParallel(true);
        } else {
            factory.setParallel(false);
        }
        factory.setMaximumQueueMemory(1000);
        factory.setDispatcherThreads(10);
        factory.setBatchSize(1000);
        factory.setIsMetaQueue(true);
        if (attributes.getDataPolicy().withPersistence()) {
            factory.setPersistent(true);
        }
        factory.setDiskStoreName(attributes.getDiskStoreName());
        factory.setDiskSynchronous(true);
        factory.setForwardExpirationDestroy(true);
        return factory;
    }

    private AsyncEventQueue createAEQ(AsyncEventQueueFactoryImpl factory, String aeqId) {
        if (factory == null) {
            return null;
        }
        LuceneEventListener listener = new LuceneEventListener(this.repositoryManager);
        factory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)new LuceneEventSubstitutionFilter());
        AsyncEventQueue indexQueue = factory.create(aeqId, (AsyncEventListener)listener);
        return indexQueue;
    }

    protected void addExtension(LocalRegion dataRegion) {
        LuceneIndexCreation creation = new LuceneIndexCreation();
        creation.setName(this.getName());
        creation.addFieldNames(this.getFieldNames());
        creation.setRegion((Region)dataRegion);
        creation.setFieldAnalyzers(this.getFieldAnalyzers());
        dataRegion.getExtensionPoint().addExtension((Extension)creation);
    }

    @Override
    public void destroy(boolean initiator) {
        Extension extensionToDelete = null;
        for (Extension extension : this.getDataRegion().getExtensionPoint().getExtensions()) {
            LuceneIndexCreation index = (LuceneIndexCreation)extension;
            if (!index.getName().equals(this.indexName)) continue;
            extensionToDelete = extension;
            break;
        }
        if (extensionToDelete != null) {
            this.getDataRegion().getExtensionPoint().removeExtension(extensionToDelete);
        }
        this.destroyAsyncEventQueue(initiator);
        this.repositoryManager.close();
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionAttributes<K, V> attributes) {
        InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true);
        try {
            return this.cache.createVMRegion(regionName, attributes, ira);
        }
        catch (Exception e) {
            InternalGemFireError ige = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            ige.initCause((Throwable)e);
            throw ige;
        }
    }

    private void destroyAsyncEventQueue(boolean initiator) {
        LocalRegion region;
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
        AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)this.cache.getAsyncEventQueue(aeqId);
        if (aeq != null) {
            aeq.stop();
        }
        if (!(region = this.getDataRegion()).isDestroyed()) {
            region.getAttributesMutator().removeAsyncEventQueueId(aeqId);
        }
        if (aeq != null) {
            aeq.destroy(initiator);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroyed aeqId=" + aeqId);
        }
    }
}

