/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.cache.lucene.LuceneIndexFactory;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexFactoryImpl
implements LuceneIndexFactory {
    private final LuceneServiceImpl service;
    private final Map<String, Analyzer> fields = new LinkedHashMap<String, Analyzer>();

    public LuceneIndexFactoryImpl(LuceneServiceImpl luceneService) {
        this.service = luceneService;
    }

    @Override
    public LuceneIndexFactory addField(String name) {
        return this.addField(name, (Analyzer)new StandardAnalyzer());
    }

    @Override
    public LuceneIndexFactory setFields(String ... fields) {
        this.fields.clear();
        for (String field : fields) {
            this.addField(field);
        }
        return this;
    }

    @Override
    public LuceneIndexFactory addField(String name, Analyzer analyzer) {
        this.fields.put(name, analyzer);
        return this;
    }

    @Override
    public LuceneIndexFactory setFields(Map<String, Analyzer> fieldMap) {
        this.fields.clear();
        this.fields.putAll(fieldMap);
        return this;
    }

    @Override
    public void create(String indexName, String regionPath) {
        this.service.createIndex(indexName, regionPath, this.fields);
    }
}

