/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;

public class SerializerUtil {
    private static final String KEY_FIELD = "_KEY";
    private static final Set<Class> SUPPORTED_PRIMITIVE_TYPES;
    private static final ThreadLocal<ByteArrayOutputStream> LOCAL_BUFFER;

    private SerializerUtil() {
    }

    public static void addKey(Object key, Document doc) {
        if (key instanceof String) {
            doc.add((IndexableField)new StringField(KEY_FIELD, (String)key, Field.Store.YES));
        } else {
            doc.add((IndexableField)new StringField(KEY_FIELD, SerializerUtil.keyToBytes(key), Field.Store.YES));
        }
    }

    public static boolean addField(Document doc, String field, Object fieldValue) {
        Class<?> clazz = fieldValue.getClass();
        if (clazz == String.class) {
            doc.add((IndexableField)new TextField(field, (String)fieldValue, Field.Store.NO));
        } else if (clazz == Long.class) {
            doc.add((IndexableField)new LongPoint(field, new long[]{(Long)fieldValue}));
        } else if (clazz == Integer.class) {
            doc.add((IndexableField)new IntPoint(field, new int[]{(Integer)fieldValue}));
        } else if (clazz == Float.class) {
            doc.add((IndexableField)new FloatPoint(field, new float[]{((Float)fieldValue).floatValue()}));
        } else if (clazz == Double.class) {
            doc.add((IndexableField)new DoublePoint(field, new double[]{(Double)fieldValue}));
        } else {
            return false;
        }
        return true;
    }

    public static boolean isSupported(Class<?> type) {
        return SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public static Collection<Class> supportedPrimitiveTypes() {
        return SUPPORTED_PRIMITIVE_TYPES;
    }

    public static Object getKey(Document doc) {
        IndexableField field = doc.getField(KEY_FIELD);
        if (field.stringValue() != null) {
            return field.stringValue();
        }
        return SerializerUtil.keyFromBytes(field.binaryValue());
    }

    public static Term getKeyTerm(Document doc) {
        IndexableField field = doc.getField(KEY_FIELD);
        if (field.stringValue() != null) {
            return new Term(KEY_FIELD, field.stringValue());
        }
        return new Term(KEY_FIELD, field.binaryValue());
    }

    public static Term toKeyTerm(Object key) {
        if (key instanceof String) {
            return new Term(KEY_FIELD, (String)key);
        }
        return new Term(KEY_FIELD, SerializerUtil.keyToBytes(key));
    }

    private static Object keyFromBytes(BytesRef bytes) {
        try {
            return BlobHelper.deserializeBlob((byte[])bytes.bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError((Throwable)e);
        }
    }

    private static BytesRef keyToBytes(Object key) {
        ByteArrayOutputStream buffer = LOCAL_BUFFER.get();
        try {
            DataOutputStream out = new DataOutputStream(buffer);
            DataSerializer.writeObject((Object)key, (DataOutput)out);
            out.flush();
            BytesRef result = new BytesRef(buffer.toByteArray());
            buffer.reset();
            return result;
        }
        catch (IOException e) {
            throw new InternalGemFireError("Unable to serialize key", (Throwable)e);
        }
    }

    static {
        HashSet<Class<Number>> primitiveTypes = new HashSet<Class<Number>>();
        primitiveTypes.add(String.class);
        primitiveTypes.add(Long.TYPE);
        primitiveTypes.add(Integer.TYPE);
        primitiveTypes.add(Float.TYPE);
        primitiveTypes.add(Double.TYPE);
        primitiveTypes.add(Long.class);
        primitiveTypes.add(Integer.class);
        primitiveTypes.add(Float.class);
        primitiveTypes.add(Double.class);
        SUPPORTED_PRIMITIVE_TYPES = Collections.unmodifiableSet(primitiveTypes);
        LOCAL_BUFFER = new ThreadLocal<ByteArrayOutputStream>(){

            @Override
            protected ByteArrayOutputStream initialValue() {
                return new ByteArrayOutputStream();
            }
        };
    }
}

