/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.partition;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketRegion;

public class BucketTargetingMap<K, V>
extends AbstractMap<K, V> {
    private final Region<K, V> region;
    public Object callbackArg;

    public BucketTargetingMap(BucketRegion region, int bucketId) {
        this.callbackArg = bucketId;
        this.region = region;
    }

    @Override
    public Set<K> keySet() {
        return this.region.keySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            this.region.create(key, value, this.callbackArg);
        }
        catch (EntryExistsException e) {
            return (V)e.getOldValue();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return (V)this.region.get(key, this.callbackArg);
    }

    @Override
    public V remove(Object key) {
        try {
            Object oldValue = this.region.get(key, this.callbackArg);
            this.region.destroy(key, this.callbackArg);
            return (V)oldValue;
        }
        catch (EntryNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.region.get(key, this.callbackArg) != null;
    }

    @Override
    public V put(K key, V value) {
        return (V)this.region.put(key, value, this.callbackArg);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.region.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BucketTargetingMap that = (BucketTargetingMap)o;
        if (!this.region.getFullPath().equals(that.region.getFullPath())) {
            return false;
        }
        return this.callbackArg.equals(that.callbackArg);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.region.hashCode();
        result = 31 * result + this.callbackArg.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "BucketTargetingMap{region=" + this.region.getFullPath() + ", callbackArg=" + this.callbackArg + '}';
    }
}

