/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.commands;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneQueryInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneSearchResults;
import org.apache.geode.cache.lucene.internal.cli.commands.LuceneCommandBase;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneSearchIndexFunction;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.exceptions.UserErrorException;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneSearchIndexCommand
extends LuceneCommandBase {
    private static final LuceneSearchIndexFunction searchIndexFunction = new LuceneSearchIndexFunction();
    private List<LuceneSearchResults> searchResults = null;

    @CliCommand(value={"search lucene"}, help="Search lucene index")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel searchIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to search.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be searched.") String regionPath, @CliOption(key={"queryString", "queryStrings"}, mandatory=true, help="Query string to search the lucene index") String queryString, @CliOption(key={"defaultField"}, mandatory=true, help="Default field to search in") String defaultField, @CliOption(key={"limit"}, unspecifiedDefaultValue="-1", help="Number of search results needed") int limit, @CliOption(key={"keys-only"}, unspecifiedDefaultValue="false", help="Return only keys of search results.") boolean keysOnly) throws Exception {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionPath);
        LuceneQueryInfo queryInfo = new LuceneQueryInfo(indexName, regionPath, queryString, defaultField, limit, keysOnly);
        this.searchResults = this.getSearchResults(queryInfo);
        return this.displayResults(this.getPageSize(), keysOnly);
    }

    protected int getPageSize() {
        return Integer.MAX_VALUE;
    }

    private List<LuceneSearchResults> getSearchResults(LuceneQueryInfo queryInfo) throws Exception {
        ResultCollector<?, ?> rc = this.executeSearch(queryInfo);
        List functionResults = (List)rc.getResult();
        return functionResults.stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    protected ResultCollector<?, ?> executeSearch(LuceneQueryInfo queryInfo) throws Exception {
        return this.executeFunctionOnRegion((Function)searchIndexFunction, queryInfo, false);
    }

    private ResultModel getResults(int fromIndex, int toIndex, boolean keysonly) throws Exception {
        ResultModel result = new ResultModel();
        TabularResultModel table = result.addTable("lucene-indexes");
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!this.searchResults.get(i).getExceptionFlag()) {
                table.accumulate("key", this.searchResults.get(i).getKey());
                if (keysonly) continue;
                table.accumulate("value", this.searchResults.get(i).getValue());
                table.accumulate("score", Float.toString(this.searchResults.get(i).getScore()));
                continue;
            }
            throw new UserErrorException(this.searchResults.get(i).getExceptionMessage());
        }
        return result;
    }

    protected Gfsh initGfsh() {
        return Gfsh.getCurrentInstance();
    }

    private ResultModel displayResults(int pageSize, boolean keysOnly) throws Exception {
        if (this.searchResults.size() == 0) {
            return ResultModel.createInfo((String)"No results");
        }
        Gfsh gfsh = this.initGfsh();
        boolean pagination = this.searchResults.size() > pageSize;
        int fromIndex = 0;
        int toIndex = pageSize < this.searchResults.size() ? pageSize : this.searchResults.size();
        int currentPage = 1;
        int totalPages = (int)Math.ceil((float)this.searchResults.size() / (float)pageSize);
        boolean skipDisplay = false;
        String step = null;
        block10: while (true) {
            if (!skipDisplay) {
                ResultModel resultModel = this.getResults(fromIndex, toIndex, keysOnly);
                if (!pagination) {
                    return resultModel;
                }
                Gfsh.println();
                CommandResult commandResult = new CommandResult(resultModel);
                while (commandResult.hasNextLine()) {
                    gfsh.printAsInfo(commandResult.nextLine());
                }
                commandResult.resetToFirstLine();
                gfsh.printAsInfo("\t\tPage " + currentPage + " of " + totalPages);
                String message = "Press n to move to next page, q to quit and p to previous page : ";
                step = gfsh.interact(message);
            }
            switch (step) {
                case "n": {
                    if (currentPage == totalPages) {
                        gfsh.printAsInfo("No more results to display.");
                        step = gfsh.interact("Press p to move to last page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    ++currentPage;
                    fromIndex = toIndex;
                    toIndex = pageSize + fromIndex >= this.searchResults.size() ? this.searchResults.size() : pageSize + fromIndex;
                    continue block10;
                }
                case "p": {
                    if (currentPage == 1) {
                        gfsh.printAsInfo("At the top of the search results.");
                        step = gfsh.interact("Press n to move to the first page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    --currentPage;
                    int current = fromIndex;
                    toIndex = fromIndex;
                    fromIndex = current - pageSize <= 0 ? 0 : current - pageSize;
                    continue block10;
                }
                case "q": {
                    return ResultModel.createInfo((String)"Search complete.");
                }
            }
            Gfsh.println((Object)"Invalid option");
        }
    }

    @Override
    @CliAvailabilityIndicator(value={"search lucene"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

