/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneIndexNotFoundException;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationInProgressException;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexResultCollector;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;

public class LuceneQueryFunction
implements InternalFunction<LuceneFunctionContext> {
    private static final long serialVersionUID = 1L;
    public static final String ID = LuceneQueryFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext<LuceneFunctionContext> context) {
        PartitionedRegionFunctionResultSender resultSender;
        Version clientVersion;
        if (context.getResultSender() instanceof PartitionedRegionFunctionResultSender && (clientVersion = (resultSender = (PartitionedRegionFunctionResultSender)context.getResultSender()).getClientVersion()) != null && clientVersion.ordinal() < Version.GEODE_1_6_0.ordinal()) {
            this.execute(context, true);
            return;
        }
        this.execute(context, false);
    }

    private void handleIfRetryNeededOnException(LuceneIndexCreationInProgressException ex, RegionFunctionContext ctx) {
        PartitionedRegion userDataRegion = (PartitionedRegion)ctx.getDataSet();
        Set remoteMembers = userDataRegion.getRegionAdvisor().adviseAllPRNodes();
        if (!remoteMembers.isEmpty()) {
            for (InternalDistributedMember remoteMember : remoteMembers) {
                if (remoteMember.getVersionObject().ordinal() >= Version.GEODE_1_6_0.ordinal()) continue;
                this.execute((FunctionContext<LuceneFunctionContext>)ctx, true);
                return;
            }
        }
        throw new FunctionException((Throwable)((Object)new LuceneQueryException("Lucene Index is not available, currently indexing")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext<LuceneFunctionContext> context, boolean waitForRepository) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        ResultSender resultSender = ctx.getResultSender();
        Region region = ctx.getDataSet();
        LuceneFunctionContext searchContext = (LuceneFunctionContext)ctx.getArguments();
        if (searchContext == null) {
            throw new IllegalArgumentException("Missing search context");
        }
        LuceneQueryProvider queryProvider = searchContext.getQueryProvider();
        if (queryProvider == null) {
            throw new IllegalArgumentException("Missing query provider");
        }
        InternalLuceneIndex index = this.getLuceneIndex(region, searchContext);
        if (index == null) {
            throw new LuceneIndexNotFoundException(searchContext.getIndexName(), region.getFullPath());
        }
        RepositoryManager repoManager = index.getRepositoryManager();
        LuceneIndexStats stats = index.getIndexStats();
        Query query = this.getQuery(queryProvider, index);
        if (logger.isDebugEnabled()) {
            logger.debug("Executing lucene query: {}, on region {}", (Object)query, (Object)region.getFullPath());
        }
        int resultLimit = searchContext.getLimit();
        TopEntriesCollectorManager manager = searchContext.getCollectorManager();
        if (manager == null) {
            manager = new TopEntriesCollectorManager(null, resultLimit);
        }
        ArrayList results = new ArrayList();
        TopEntriesCollector mergedResult = null;
        try {
            long start = stats.startQuery();
            Collection<IndexRepository> repositories = null;
            try {
                repositories = repoManager.getRepositories(ctx, waitForRepository);
                for (IndexRepository repo : repositories) {
                    Object collector = manager.newCollector(repo.toString());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Executing search on repo: " + repo.toString());
                    }
                    repo.query(query, resultLimit, (IndexResultCollector)collector);
                    results.add(collector);
                }
                mergedResult = (TopEntriesCollector)manager.reduce(results);
                stats.endQuery(start, mergedResult == null ? 0 : mergedResult.size());
            }
            catch (Throwable throwable) {
                stats.endQuery(start, mergedResult == null ? 0 : mergedResult.size());
                throw throwable;
            }
            stats.incNumberOfQueryExecuted();
            resultSender.lastResult((Object)mergedResult);
        }
        catch (IOException | CacheClosedException | BucketNotFoundException | PrimaryBucketException e) {
            logger.debug("Exception during lucene query function", e);
            throw new InternalFunctionInvocationTargetException(e);
        }
        catch (LuceneIndexCreationInProgressException ex) {
            if (!waitForRepository) {
                this.handleIfRetryNeededOnException(ex, ctx);
            }
            logger.warn("The lucene query should have waited for the index to be created");
            throw new FunctionException((Throwable)((Object)new LuceneQueryException("Lucene Index is not available, currently indexing")));
        }
    }

    private InternalLuceneIndex getLuceneIndex(Region region, LuceneFunctionContext<IndexResultCollector> searchContext) {
        InternalLuceneIndex index;
        block5: {
            LuceneService service = LuceneServiceProvider.get((GemFireCache)region.getCache());
            index = null;
            try {
                index = (InternalLuceneIndex)service.getIndex(searchContext.getIndexName(), region.getFullPath());
                if (index != null) break block5;
                while (service instanceof LuceneServiceImpl && ((LuceneServiceImpl)service).getDefinedIndex(searchContext.getIndexName(), region.getFullPath()) != null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    region.getCache().getCancelCriterion().checkCancelInProgress(null);
                }
                index = (InternalLuceneIndex)service.getIndex(searchContext.getIndexName(), region.getFullPath());
            }
            catch (CacheClosedException e) {
                throw new InternalFunctionInvocationTargetException("Cache is closed when attempting to retrieve index:" + region.getFullPath(), (Throwable)e);
            }
        }
        return index;
    }

    private Query getQuery(LuceneQueryProvider queryProvider, LuceneIndex index) {
        Query query = null;
        try {
            query = queryProvider.getQuery(index);
        }
        catch (LuceneQueryException e) {
            logger.warn("", (Throwable)((Object)e));
            throw new FunctionException((Throwable)((Object)e));
        }
        return query;
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(ResourcePermissions.DATA_READ);
    }
}

