/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneCommandBase;
import org.apache.geode.cache.lucene.internal.cli.LuceneFunctionSerializable;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneCreateIndexFunction;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneCreateIndexCommand
extends LuceneCommandBase {
    private static final LuceneCreateIndexFunction createIndexFunction = new LuceneCreateIndexFunction();

    @CliCommand(value={"create lucene index"}, help="Create a lucene index that can be used to execute queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to create.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region on which to create the lucene index.") String regionPath, @CliOption(key={"field"}, mandatory=true, help="Fields on the region values which are stored in the lucene index.\nUse __REGION_VALUE_FIELD if the entire region value should be indexed.\n__REGION_VALUE_FIELD is valid only if the region values are strings or numbers.") String[] fields, @CliOption(key={"analyzer"}, help="Type of the analyzer for each field.\nUse the case sensitive keyword DEFAULT or leave an analyzer blank to use the default standard analyzer.") String[] analyzers, @CliOption(key={"serializer"}, help="Fully qualified class name of the LuceneSerializer to use with this index.\n") String serializer) throws CommandResultException {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE, "LUCENE");
        InternalCache cache = (InternalCache)this.getCache();
        String[] trimmedFields = (String[])Arrays.stream(fields).map(String::trim).toArray(String[]::new);
        LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath, trimmedFields, analyzers, serializer);
        ResultCollector<?, ?> rc = this.executeFunctionOnAllMembers((Function)createIndexFunction, indexInfo);
        List funcResults = (List)rc.getResult();
        XmlEntity xmlEntity = funcResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
        ResultModel result = new ResultModel();
        TabularResultModel tabularResult = result.addTable("lucene-indexes");
        for (CliFunctionResult cliFunctionResult : funcResults) {
            tabularResult.accumulate("Member", cliFunctionResult.getMemberIdOrName());
            if (cliFunctionResult.isSuccessful()) {
                tabularResult.accumulate("Status", "Successfully created lucene index");
                continue;
            }
            tabularResult.accumulate("Status", "Failed: " + cliFunctionResult.getMessage());
        }
        InternalConfigurationPersistenceService configurationPersistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (xmlEntity != null) {
            if (configurationPersistenceService == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                configurationPersistenceService.addXmlEntity(xmlEntity, null);
            }
        }
        return result;
    }

    protected ResultCollector<?, ?> executeFunctionOnAllMembers(Function function, LuceneFunctionSerializable functionArguments) throws IllegalArgumentException {
        Set targetMembers = this.getAllNormalMembers();
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    @Override
    @CliAvailabilityIndicator(value={"create lucene index"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

