/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import java.util.HashSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.internal.InternalEntity;

public class LuceneListIndexFunction
extends FunctionAdapter
implements InternalEntity {
    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    public String getId() {
        return LuceneListIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        HashSet<LuceneIndexDetails> indexDetailsSet = new HashSet<LuceneIndexDetails>();
        Cache cache = this.getCache();
        String serverName = cache.getDistributedSystem().getDistributedMember().getName();
        LuceneServiceImpl service = (LuceneServiceImpl)LuceneServiceProvider.get((GemFireCache)cache);
        for (LuceneIndex index : service.getAllIndexes()) {
            indexDetailsSet.add(new LuceneIndexDetails((LuceneIndexImpl)index, serverName));
        }
        for (LuceneIndexCreationProfile profile : service.getAllDefinedIndexes()) {
            indexDetailsSet.add(new LuceneIndexDetails(profile, serverName));
        }
        context.getResultSender().lastResult(indexDetailsSet);
    }
}

