/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.lucene.analysis.Analyzer;

public class LuceneIndexDetails
implements Comparable<LuceneIndexDetails>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final String regionPath;
    private final String serverName;
    private final String[] searchableFieldNames;
    private Map<String, String> fieldAnalyzers = null;
    private final Map<String, Integer> indexStats;
    private boolean initialized;

    public LuceneIndexDetails(String indexName, String regionPath, String[] searchableFieldNames, Map<String, Analyzer> fieldAnalyzers, LuceneIndexStats indexStats, boolean initialized, String serverName) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.serverName = serverName;
        this.searchableFieldNames = searchableFieldNames;
        this.fieldAnalyzers = this.getFieldAnalyzerStrings(fieldAnalyzers);
        this.indexStats = this.getIndexStatsMap(indexStats);
        this.initialized = initialized;
    }

    public LuceneIndexDetails(LuceneIndexImpl index, String serverName) {
        this(index.getName(), index.getRegionPath(), index.getFieldNames(), index.getFieldAnalyzers(), index.getIndexStats(), true, serverName);
    }

    public LuceneIndexDetails(LuceneIndexCreationProfile indexProfile, String serverName) {
        this(indexProfile.getIndexName(), indexProfile.getRegionPath(), indexProfile.getFieldNames(), null, null, false, serverName);
        this.fieldAnalyzers = this.getFieldAnalyzerStringsFromProfile(indexProfile.getFieldAnalyzers());
    }

    public Map<String, Integer> getIndexStats() {
        return this.indexStats;
    }

    private Map<String, Integer> getIndexStatsMap(LuceneIndexStats indexStats) {
        HashMap<String, Integer> statsMap = new HashMap<String, Integer>();
        if (indexStats == null) {
            return statsMap;
        }
        statsMap.put("queryExecutions", indexStats.getQueryExecutions());
        statsMap.put("updates", indexStats.getUpdates());
        statsMap.put("commits", indexStats.getCommits());
        statsMap.put("documents", indexStats.getDocuments());
        return statsMap;
    }

    public String getIndexStatsString() {
        return this.indexStats.toString();
    }

    private Map<String, String> getFieldAnalyzerStrings(Map<String, Analyzer> fieldAnalyzers) {
        if (fieldAnalyzers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, Analyzer> entry : fieldAnalyzers.entrySet()) {
            Analyzer analyzer = entry.getValue();
            if (analyzer == null) continue;
            results.put(entry.getKey(), analyzer.getClass().getSimpleName());
        }
        return results;
    }

    private Map<String, String> getFieldAnalyzerStringsFromProfile(Map<String, String> fieldAnalyzers) {
        if (fieldAnalyzers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldAnalyzers.entrySet()) {
            String analyzer = entry.getValue();
            if (analyzer == null) continue;
            results.put(entry.getKey(), analyzer);
        }
        return results;
    }

    public String getSearchableFieldNamesString() {
        return Arrays.asList(this.searchableFieldNames).toString();
    }

    public String getFieldAnalyzersString() {
        return this.fieldAnalyzers.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n\tIndex Name = " + this.indexName);
        buffer.append(",\tRegion Path = " + this.regionPath);
        buffer.append(",\tIndexed Fields = " + this.getSearchableFieldNamesString());
        buffer.append(",\tField Analyzer = " + this.getFieldAnalyzersString());
        buffer.append(",\tStatus =\n\t" + this.getInitialized());
        buffer.append(",\tIndex Statistics =\n\t" + this.getIndexStatsString());
        buffer.append("\n}\n");
        return buffer.toString();
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    private static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return obj1 == null && obj2 == null ? 0 : (obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2)));
    }

    @Override
    public int compareTo(LuceneIndexDetails indexDetails) {
        int comparisonValue = LuceneIndexDetails.compare(this.getIndexName(), indexDetails.getIndexName());
        return comparisonValue != 0 ? comparisonValue : LuceneIndexDetails.compare(this.getRegionPath(), indexDetails.getRegionPath());
    }

    public String getServerName() {
        return this.serverName;
    }
}

