/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.partition.PartitionListenerAdapter;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LucenePrimaryBucketListener
extends PartitionListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRepositoryManager lucenePartitionRepositoryManager;
    private final DM dm;

    public LucenePrimaryBucketListener(PartitionedRepositoryManager partitionedRepositoryManager, DM dm) {
        this.lucenePartitionRepositoryManager = partitionedRepositoryManager;
        this.dm = dm;
    }

    public void afterPrimary(int bucketId) {
        this.dm.getWaitingThreadPool().execute(() -> {
            try {
                this.lucenePartitionRepositoryManager.getRepository(bucketId);
            }
            catch (BucketNotFoundException e) {
                logger.warn("Index repository could not be created when index chunk region bucket became primary. Deferring index repository to be created lazily during lucene query execution." + (Object)((Object)e));
            }
        });
    }
}

