/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.internal.LuceneIndexForPartitionedRegion;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.directory.RegionDirectory;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexRepositoryImpl;
import org.apache.geode.cache.lucene.internal.repository.serializer.LuceneSerializer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class IndexRepositoryFactory {
    public IndexRepository createIndexRepository(Integer bucketId, LuceneSerializer serializer, LuceneIndexImpl index, PartitionedRegion userRegion) throws IOException {
        LuceneIndexForPartitionedRegion indexForPR = (LuceneIndexForPartitionedRegion)index;
        BucketRegion fileBucket = this.getMatchingBucket(indexForPR.getFileRegion(), bucketId);
        BucketRegion chunkBucket = this.getMatchingBucket(indexForPR.getChunkRegion(), bucketId);
        BucketRegion dataBucket = this.getMatchingBucket(userRegion, bucketId);
        if (fileBucket == null || chunkBucket == null) {
            return null;
        }
        RegionDirectory dir = new RegionDirectory((ConcurrentMap<String, File>)fileBucket, (ConcurrentMap<ChunkKey, byte[]>)chunkBucket, indexForPR.getFileSystemStats());
        IndexWriterConfig config = new IndexWriterConfig(indexForPR.getAnalyzer());
        IndexWriter writer = new IndexWriter((Directory)dir, config);
        IndexRepositoryImpl repo = new IndexRepositoryImpl((Region<?, ?>)fileBucket, writer, serializer, indexForPR.getIndexStats(), (Region<?, ?>)dataBucket);
        return repo;
    }

    protected BucketRegion getMatchingBucket(PartitionedRegion region, Integer bucketId) {
        region.getOrCreateNodeForBucketWrite(bucketId.intValue(), null);
        return region.getDataStore().getLocalBucketById(bucketId);
    }
}

