/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LuceneEventListener
implements AsyncEventListener {
    Logger logger = LogService.getLogger();
    private final RepositoryManager repositoryManager;

    public LuceneEventListener(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvents(List<AsyncEvent> events) {
        DefaultQuery.setPdxReadSerialized((boolean)true);
        HashSet<IndexRepository> affectedRepos = new HashSet<IndexRepository>();
        try {
            for (AsyncEvent event : events) {
                Region region = event.getRegion();
                Object key = event.getKey();
                Object callbackArgument = event.getCallbackArgument();
                IndexRepository repository = this.repositoryManager.getRepository(region, key, callbackArgument);
                Operation op = event.getOperation();
                if (op.isCreate()) {
                    repository.update(key, event.getDeserializedValue());
                } else if (op.isUpdate()) {
                    repository.update(key, event.getDeserializedValue());
                } else if (op.isDestroy()) {
                    repository.delete(key);
                } else if (op.isInvalidate()) {
                    repository.delete(key);
                } else {
                    throw new InternalGemFireError("Unhandled operation " + op + " on " + event.getRegion());
                }
                affectedRepos.add(repository);
            }
            for (IndexRepository repo : affectedRepos) {
                repo.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (RegionDestroyedException | BucketNotFoundException | PrimaryBucketException e) {
            this.logger.debug("Bucket not found while saving to lucene index: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logger.error("Unable to save to lucene index", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DefaultQuery.setPdxReadSerialized((boolean)false);
        }
    }
}

