/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.assertj.core.api.Assertions;

public class ExecutorServiceRule
extends SerializableExternalResource {
    protected final int threadCount;
    protected final boolean enableAwaitTermination;
    protected final long awaitTerminationTimeout;
    protected final TimeUnit awaitTerminationTimeUnit;
    protected final boolean awaitTerminationBeforeShutdown;
    protected final boolean useShutdown;
    protected final boolean useShutdownNow;
    protected volatile transient ExecutorService executor;

    public static Builder builder() {
        return new Builder();
    }

    protected ExecutorServiceRule(Builder builder) {
        this.threadCount = builder.threadCount;
        this.enableAwaitTermination = builder.enableAwaitTermination;
        this.awaitTerminationTimeout = builder.awaitTerminationTimeout;
        this.awaitTerminationTimeUnit = builder.awaitTerminationTimeUnit;
        this.awaitTerminationBeforeShutdown = builder.awaitTerminationBeforeShutdown;
        this.useShutdown = builder.useShutdown;
        this.useShutdownNow = builder.useShutdownNow;
    }

    public ExecutorServiceRule() {
        this.threadCount = 1;
        this.enableAwaitTermination = false;
        this.awaitTerminationTimeout = 0L;
        this.awaitTerminationTimeUnit = TimeUnit.NANOSECONDS;
        this.awaitTerminationBeforeShutdown = false;
        this.useShutdown = false;
        this.useShutdownNow = true;
    }

    public ExecutorServiceRule(int threadCount) {
        this.threadCount = threadCount;
        this.enableAwaitTermination = false;
        this.awaitTerminationTimeout = 0L;
        this.awaitTerminationTimeUnit = TimeUnit.NANOSECONDS;
        this.awaitTerminationBeforeShutdown = false;
        this.useShutdown = false;
        this.useShutdownNow = true;
    }

    public void before() {
        this.executor = this.threadCount > 1 ? Executors.newFixedThreadPool(this.threadCount) : Executors.newSingleThreadExecutor();
    }

    public void after() {
        if (this.awaitTerminationBeforeShutdown) {
            this.enableAwaitTermination();
        }
        if (this.useShutdown) {
            this.executor.shutdown();
        } else if (this.useShutdownNow) {
            this.executor.shutdownNow();
        }
        if (!this.awaitTerminationBeforeShutdown) {
            this.enableAwaitTermination();
        }
    }

    private void enableAwaitTermination() {
        if (this.enableAwaitTermination) {
            try {
                this.executor.awaitTermination(this.awaitTerminationTimeout, this.awaitTerminationTimeUnit);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.executor);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.executor);
    }

    public static class Builder {
        protected int threadCount = 1;
        protected boolean enableAwaitTermination = false;
        protected long awaitTerminationTimeout = 0L;
        protected TimeUnit awaitTerminationTimeUnit = TimeUnit.NANOSECONDS;
        protected boolean awaitTerminationBeforeShutdown = true;
        protected boolean useShutdown = false;
        protected boolean useShutdownNow = true;

        protected Builder() {
        }

        public Builder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder awaitTermination(long timeout, TimeUnit unit) {
            this.enableAwaitTermination = true;
            this.awaitTerminationTimeout = timeout;
            this.awaitTerminationTimeUnit = unit;
            return this;
        }

        public Builder useShutdown() {
            this.useShutdown = true;
            this.useShutdownNow = false;
            return this;
        }

        public Builder useShutdownNow() {
            this.useShutdown = false;
            this.useShutdownNow = true;
            return this;
        }

        public Builder awaitTerminationBeforeShutdown() {
            this.awaitTerminationBeforeShutdown = true;
            return this;
        }

        public Builder awaitTerminationAfterShutdown() {
            this.awaitTerminationBeforeShutdown = false;
            return this;
        }

        public ExecutorServiceRule build() {
            Assertions.assertThat((int)this.threadCount).isGreaterThan(0);
            return new ExecutorServiceRule(this);
        }
    }
}

