/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules.gfsh;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.test.junit.rules.gfsh.internal.ProcessLogger;

public class GfshExecution {
    private final Process process;
    private final File workingDir;
    private final ProcessLogger processLogger;

    protected GfshExecution(Process process, File workingDir) {
        this.process = process;
        this.workingDir = workingDir;
        this.processLogger = new ProcessLogger(process, workingDir.getName());
    }

    public String getOutputText() {
        return this.processLogger.getOutputText();
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public Process getProcess() {
        return this.process;
    }

    public List<File> getServerDirs() {
        File[] potentialMemberDirectories = this.workingDir.listFiles(File::isDirectory);
        Predicate<File> isServerDir = directory -> Arrays.stream(directory.list()).anyMatch(filename -> filename.endsWith("server.pid"));
        return Arrays.stream(potentialMemberDirectories).filter(isServerDir).collect(Collectors.toList());
    }

    public List<File> getLocatorDirs() {
        File[] potentialMemberDirectories = this.workingDir.listFiles(File::isDirectory);
        Predicate<File> isLocatorDir = directory -> Arrays.stream(directory.list()).anyMatch(filename -> filename.endsWith("locator.pid"));
        return Arrays.stream(potentialMemberDirectories).filter(isLocatorDir).collect(Collectors.toList());
    }

    public void printLogFiles() {
        System.out.println("Printing contents of all log files found in " + this.workingDir.getAbsolutePath());
        List<File> logFiles = this.findLogFiles();
        for (File logFile : logFiles) {
            System.out.println("Contents of " + logFile.getAbsolutePath());
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), Charsets.UTF_8));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (IOException ignored) {
                System.out.println("Unable to print log due to: " + ExceptionUtils.getStackTrace((Throwable)ignored));
            }
        }
    }

    private List<File> findLogFiles() {
        List<File> servers = this.getServerDirs();
        List<File> locators = this.getLocatorDirs();
        return Stream.concat(servers.stream(), locators.stream()).flatMap(this::findLogFiles).collect(Collectors.toList());
    }

    private Stream<File> findLogFiles(File memberDir) {
        return Arrays.stream(memberDir.listFiles()).filter(File::isFile).filter(file -> file.getName().toLowerCase().endsWith(".log"));
    }
}

