/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.util.Locale;
import java.util.function.Consumer;
import org.junit.rules.ExternalResource;

public class RestoreLocaleRule
extends ExternalResource {
    private Locale originalLocale;
    private final Locale initLocale;
    private final Consumer<Locale> consumer;

    public RestoreLocaleRule(Locale initLocale, Consumer<Locale> consumer) {
        this.initLocale = initLocale;
        this.consumer = consumer;
    }

    public RestoreLocaleRule(Locale initLocale) {
        this(initLocale, null);
    }

    public RestoreLocaleRule(Consumer<Locale> consumer) {
        this(Locale.getDefault(), consumer);
    }

    public RestoreLocaleRule() {
        this(Locale.getDefault(), null);
    }

    protected void before() throws Throwable {
        this.originalLocale = Locale.getDefault();
        Locale.setDefault(this.initLocale);
        if (this.consumer != null) {
            this.consumer.accept(this.initLocale);
        }
    }

    protected void after() {
        Locale.setDefault(this.originalLocale);
        if (this.consumer != null) {
            this.consumer.accept(this.originalLocale);
        }
    }
}

