/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.compiler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassNameExtractor {
    private static final Pattern EXTRACT_CLASS_NAME_REGEX = Pattern.compile("(?:public|private|protected)* *(?:abstract)* *(?:class|interface) +(\\w+)");

    public String extractFromSourceCode(String sourceCode) {
        Matcher m = EXTRACT_CLASS_NAME_REGEX.matcher(sourceCode);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException(String.format("Unable to parse class or interface name from: \n'%s'", sourceCode));
    }
}

