/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class ClassBuilder
implements Serializable {
    private String classPath = System.getProperty("java.class.path");

    public void writeJarFromName(String className, File outputFile) throws IOException {
        this.writeJarFromContent(className, "public class " + className + "{}", outputFile);
    }

    public void writeJarFromContent(String className, String content, File outputFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        this.writeJarFromContent(className, content, fileOutputStream);
        fileOutputStream.close();
    }

    public byte[] createJarFromName(String className) throws IOException {
        return this.createJarFromClassContent(className, "public class " + className + "{}");
    }

    public byte[] createJarFromFileContent(String fileName, String content) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JarOutputStream jarOutputStream = new JarOutputStream(byteArrayOutputStream);
        JarEntry entry = new JarEntry(fileName);
        entry.setTime(System.currentTimeMillis());
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.write(content.getBytes());
        jarOutputStream.closeEntry();
        jarOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createJarFromClassContent(String className, String content) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeJarFromContent(className, content, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void writeJarFromContent(String className, String content, OutputStream outStream) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(outStream);
        String formattedName = className;
        if (!formattedName.endsWith(".class")) {
            formattedName = formattedName.concat(".class");
        }
        JarEntry entry = new JarEntry(formattedName);
        entry.setTime(System.currentTimeMillis());
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.write(this.compileClass(className, content));
        jarOutputStream.closeEntry();
        jarOutputStream.close();
    }

    public ClassLoader createClassLoaderFromContent(String className, String content) throws IOException {
        byte[] classDefinition = this.compileClass(className, content);
        SingleClassClassLoader classLoader = new SingleClassClassLoader();
        classLoader.addClass(className, classDefinition);
        return classLoader;
    }

    public byte[] compileClass(String className, String classCode) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        OutputStreamJavaFileManager fileManager = new OutputStreamJavaFileManager(this, (JavaFileManager)javaCompiler.getStandardFileManager(null, null, null), (OutputStream)byteArrayOutputStream);
        ArrayList<JavaSourceFromString> fileObjects = new ArrayList<JavaSourceFromString>();
        fileObjects.add(new JavaSourceFromString(className, classCode));
        List<String> options = Arrays.asList("-classpath", this.classPath);
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        if (!javaCompiler.getTask(null, fileManager, diagnostics, options, null, fileObjects).call().booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            for (Diagnostic d : diagnostics.getDiagnostics()) {
                String err = String.format("Compilation error: Line %d - %s%n", d.getLineNumber(), d.getMessage(null));
                errorMsg.append(err);
                System.err.print(err);
            }
            throw new IOException(errorMsg.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String addToClassPath(String path) {
        this.classPath = this.classPath + System.getProperty("path.separator") + path;
        return this.classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public class SingleClassClassLoader
    extends ClassLoader {
        public Class addClass(String className, byte[] definition) {
            return super.defineClass(className, definition, 0, definition.length);
        }
    }

    private static class OutputStreamJavaFileManager<M extends JavaFileManager>
    extends ForwardingJavaFileManager<M> {
        private OutputStream outputStream;
        final /* synthetic */ ClassBuilder this$0;

        protected OutputStreamJavaFileManager(M fileManager, OutputStream outputStream) {
            this.this$0 = var1_1;
            super(fileManager);
            this.outputStream = outputStream;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            return this.this$0.new OutputStreamSimpleFileObject(new File(className).toURI(), kind, this.outputStream);
        }
    }

    private class OutputStreamSimpleFileObject
    extends SimpleJavaFileObject {
        private OutputStream outputStream;

        protected OutputStreamSimpleFileObject(URI uri, JavaFileObject.Kind kind, OutputStream outputStream) {
            super(uri, kind);
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream openOutputStream() {
            return this.outputStream;
        }
    }

    private class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

