/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.benchmark.jmh.profilers;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectSizeAgent {
    private static volatile Instrumentation instrumentation;
    private static final Map<Class<?>, Field[]> fieldsCache;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        ObjectSizeAgent.instrumentation = instrumentation;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        ObjectSizeAgent.instrumentation = instrumentation;
    }

    private static Instrumentation getInstrumentation() {
        if (instrumentation == null) {
            throw new IllegalStateException("ObjectSizeAgent not initialized.");
        }
        return instrumentation;
    }

    public static long sizeOf(Object object) {
        if (null == object) {
            return 0L;
        }
        return ObjectSizeAgent.getInstrumentation().getObjectSize(object);
    }

    public static long sizeOfDeep(Object object) {
        if (null == object) {
            return 0L;
        }
        if (ObjectSizeAgent.isSimpleObject(object)) {
            return ObjectSizeAgent.sizeOf(object);
        }
        ArrayDeque<Object> unseen = new ArrayDeque<Object>();
        Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());
        long size = 0L;
        unseen.push(object);
        while (!unseen.isEmpty()) {
            size += ObjectSizeAgent.sizeOfDeep(unseen.pop(), unseen, seen);
        }
        return size;
    }

    private static boolean isSimpleObject(Object object) {
        Class<?> clazz = object.getClass();
        return !clazz.isArray() && ObjectSizeAgent.getFields(clazz).length == 0;
    }

    private static long sizeOfDeep(Object object, Deque<Object> unseen, Set<Object> seen) {
        block7: {
            Class<?> clazz;
            block6: {
                if (!seen.add(object)) {
                    return 0L;
                }
                clazz = object.getClass();
                if (!clazz.isArray()) break block6;
                if (clazz.getComponentType().isPrimitive()) break block7;
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ObjectSizeAgent.addIfNotNull(unseen, Array.get(object, i));
                }
                break block7;
            }
            try {
                while (null != clazz) {
                    Field[] fields;
                    for (Field field : fields = ObjectSizeAgent.getFields(clazz)) {
                        ObjectSizeAgent.addIfNotNull(unseen, field.get(object));
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return ObjectSizeAgent.sizeOf(object);
    }

    private static Field[] getFields(Class<?> clazz) {
        Field[] fields = fieldsCache.get(clazz);
        if (null != fields) {
            return fields;
        }
        return fieldsCache.computeIfAbsent(clazz, k -> {
            AccessibleObject[] filtered = ObjectSizeAgent.getFilteredFields(k.getDeclaredFields());
            Field.setAccessible(filtered, true);
            return filtered;
        });
    }

    private static Field[] getFilteredFields(Field[] fields) {
        int count = ObjectSizeAgent.getFilteredFieldsCount(fields);
        Field[] filtered = new Field[count];
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
            filtered[--count] = field;
        }
        return filtered;
    }

    private static int getFilteredFieldsCount(Field[] fields) {
        int counter = fields.length;
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) && !field.getType().isPrimitive()) continue;
            --counter;
        }
        return counter;
    }

    private static void addIfNotNull(Collection<Object> collection, Object object) {
        if (null != object) {
            collection.add(object);
        }
    }

    static {
        fieldsCache = new ConcurrentHashMap();
    }
}

