/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.benchmark.jmh.profilers;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;

public class BufferPoolProfiler
implements InternalProfiler {
    final List<BufferPoolMXBean> pools;
    private final long[] previousCount;
    private final long[] previousMemoryUsed;
    private final long[] previousTotalCapacity;

    public BufferPoolProfiler() {
        this(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class));
    }

    BufferPoolProfiler(List<BufferPoolMXBean> pools) {
        this.pools = pools;
        this.previousCount = new long[pools.size()];
        this.previousMemoryUsed = new long[pools.size()];
        this.previousTotalCapacity = new long[pools.size()];
    }

    public String getDescription() {
        return "BufferPool Profiler";
    }

    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        int i = 0;
        for (BufferPoolMXBean pool : this.pools) {
            this.previousCount[i] = pool.getCount();
            this.previousMemoryUsed[i] = pool.getMemoryUsed();
            this.previousTotalCapacity[i] = pool.getTotalCapacity();
            ++i;
        }
    }

    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        ArrayList<ScalarResult> results = new ArrayList<ScalarResult>(this.pools.size());
        int i = 0;
        for (BufferPoolMXBean pool : this.pools) {
            long count = pool.getCount();
            if (count != 0L) {
                String name = pool.getName();
                results.add(new ScalarResult(name + ".count", (double)(count - this.previousCount[i]), "B", AggregationPolicy.AVG));
                results.add(new ScalarResult(name + ".memoryUsed", (double)(pool.getMemoryUsed() - this.previousMemoryUsed[i]), "B", AggregationPolicy.AVG));
                results.add(new ScalarResult(name + ".totalCapacity", (double)(pool.getTotalCapacity() - this.previousTotalCapacity[i]), "B", AggregationPolicy.AVG));
            }
            ++i;
        }
        return results;
    }
}

