/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.geode.internal.logging.MergeLogFiles;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.logging.log4j.Logger;

public class MergeLogs {
    private static final Logger logger = LogService.getLogger();

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 1) {
            throw new IllegalArgumentException("Requires only 1  arguments : <targetDirName>");
        }
        try {
            String result = MergeLogs.mergeLogFile(args[0]).getCanonicalPath();
            System.out.println("Merged logs to: " + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void mergeLogsInNewProcess(Path logDirectory) {
        logger.info("Exporting logs merging logs" + String.valueOf(logDirectory));
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
        commandList.add("-classpath");
        commandList.add(System.getProperty("java.class.path", "."));
        commandList.add(MergeLogs.class.getName());
        commandList.add(logDirectory.toAbsolutePath().toString());
        ProcessBuilder procBuilder = new ProcessBuilder(commandList);
        StringBuilder output = new StringBuilder();
        try {
            logger.info("Exporting logs now merging logs");
            Process mergeProcess = procBuilder.redirectErrorStream(true).start();
            mergeProcess.waitFor();
            try (InputStream inputStream = mergeProcess.getInputStream();
                 BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    output.append(line).append(GfshParser.LINE_SEPARATOR);
                }
            }
            mergeProcess.destroy();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (output.toString().contains("Merged logs to: ")) {
            logger.info("Exporting logs successfully merged logs");
        } else {
            logger.error("Could not merge");
        }
    }

    protected static List<File> findLogFilesToMerge(File dir) {
        return FileUtils.listFiles((File)dir, (String[])new String[]{"log"}, (boolean)true).stream().collect(Collectors.toList());
    }

    static File mergeLogFile(String dirName) throws Exception {
        Path dir = Paths.get(dirName, new String[0]);
        List<File> logsToMerge = MergeLogs.findLogFilesToMerge(dir.toFile());
        HashMap<String, FileInputStream> logFiles = new HashMap<String, FileInputStream>();
        for (File file : logsToMerge) {
            try {
                logFiles.put(dir.relativize(file.toPath()).toString(), new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new Exception(String.valueOf(file) + " Does not exist");
            }
        }
        File mergedLogFile = null;
        try (PrintWriter mergedLog = null;){
            String mergeLog = dirName + File.separator + "merge_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".log";
            mergedLogFile = new File(mergeLog);
            mergedLog = new PrintWriter(mergedLogFile);
            MergeLogFiles.mergeLogFiles(logFiles, (PrintWriter)mergedLog);
        }
        return mergedLogFile;
    }
}

