/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.GemFireIOException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.i18n.CliStrings;

public class DiskStoreUpgrader {
    public static final String STACKTRACE_START = "--------------------------";
    private static final String DIR_ARRAY_SEPARATOR = ", ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String stackTraceString;
        boolean errored;
        block23: {
            if (args.length < 3) {
                throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
            }
            Properties prop = new Properties();
            try {
                prop.load(new StringReader(args[0] + GfshParser.LINE_SEPARATOR + args[1] + GfshParser.LINE_SEPARATOR + args[2]));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
            }
            errored = false;
            String errorString = null;
            stackTraceString = null;
            String diskStoreName = null;
            Object[] diskDirs = null;
            try {
                diskStoreName = prop.getProperty("name");
                String diskDirsStr = prop.getProperty("disk-dirs");
                diskDirs = diskDirsStr.split(",");
                String maxOpLogSize = prop.getProperty("max-oplog-size");
                long maxOplogSize = Long.parseLong(maxOpLogSize);
                DiskStoreUpgrader.upgrade(diskStoreName, (String[])diskDirs, maxOplogSize);
                if (errorString == null) break block23;
            }
            catch (GemFireIOException e) {
                errored = true;
                Throwable cause = e.getCause();
                if (cause instanceof IllegalStateException) {
                    String message = cause.getMessage();
                    errorString = DiskStoreUpgrader.stringMatches(String.format("The init file %s does not exist.", "(.*)"), message) ? CliStrings.format((String)"Cannot locate disk store \"{0}\" in directory : \"{1}\"", (Object[])new Object[]{diskStoreName, StringUtils.join((Object[])diskDirs, (String)DIR_ARRAY_SEPARATOR)}) : message;
                } else if (cause instanceof DiskAccessException) {
                    boolean isKnownCause = false;
                    Throwable nestedCause = cause.getCause();
                    if (nestedCause instanceof IOException) {
                        String message = nestedCause.getMessage();
                        if (DiskStoreUpgrader.stringMatches(String.format("The file %s is being used by another process.", "(.*)"), message)) {
                            errorString = "The disk is currently being used by another process";
                            isKnownCause = true;
                        }
                    }
                    if (!isKnownCause) {
                        errorString = CliStrings.format((String)"Can not access disk store \"{0}\" from  \"{1}\". Check gfsh logs for error.", (Object[])new Object[]{diskStoreName, StringUtils.join((Object[])diskDirs, (String)DIR_ARRAY_SEPARATOR)});
                    }
                } else {
                    errorString = e.getMessage();
                }
                stackTraceString = ExceptionUtils.getStackTrace((Throwable)e);
                if (errorString != null) {
                    System.err.println(errorString);
                }
                if (stackTraceString != null) {
                    System.err.println(STACKTRACE_START);
                    System.err.println(stackTraceString);
                }
                if (!errored) return;
                System.exit(1);
                return;
            }
            catch (IllegalArgumentException e2) {
                errored = true;
                errorString = e2.getMessage();
                stackTraceString = ExceptionUtils.getStackTrace((Throwable)e2);
                if (errorString != null) {
                    System.err.println(errorString);
                }
                if (stackTraceString != null) {
                    System.err.println(STACKTRACE_START);
                    System.err.println(stackTraceString);
                }
                if (!errored) return;
                {
                    catch (Throwable throwable) {
                        if (errorString != null) {
                            System.err.println(errorString);
                        }
                        if (stackTraceString != null) {
                            System.err.println(STACKTRACE_START);
                            System.err.println(stackTraceString);
                        }
                        if (!errored) throw throwable;
                        System.exit(1);
                        throw throwable;
                    }
                }
                System.exit(1);
                return;
            }
            System.err.println(errorString);
        }
        if (stackTraceString != null) {
            System.err.println(STACKTRACE_START);
            System.err.println(stackTraceString);
        }
        if (!errored) return;
        System.exit(1);
        return;
    }

    private static void upgrade(String diskStoreName, String[] diskDirs, long maxOplogSize) {
        Object[] dirs = null;
        if (diskDirs != null) {
            dirs = new File[diskDirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
        }
        try {
            DiskStoreImpl.offlineCompact((String)diskStoreName, (File[])dirs, (boolean)true, (long)maxOplogSize);
        }
        catch (Exception ex) {
            Object fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = (String)fieldsMessage + StringUtils.join((Object[])dirs, (String)DIR_ARRAY_SEPARATOR);
            throw new GemFireIOException(CliStrings.format((String)"Error occurred while upgrading disk store={0} {1}. Reason: {2}", (Object[])new Object[]{diskStoreName, fieldsMessage, ex.getMessage()}), (Throwable)ex);
        }
    }

    private static boolean stringMatches(String str1, String str2) {
        return Pattern.matches(str1, str2);
    }
}

