/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.management.internal.cli.GfshParser;

public class CommandStringBuilder {
    private static final String OPTION_MARKER = "--";
    private static final String EQUAL_TO = "=";
    private static final String ARG_SEPARATOR = " ";
    private static final String OPTION_SEPARATOR = " ";
    private static final String SINGLE_SPACE = " ";
    private static final String DOUBLE_QUOTE = "\"";
    private final StringBuilder buffer;
    private volatile boolean hasOptions;

    public CommandStringBuilder(String command) {
        this.buffer = new StringBuilder(command);
    }

    private static String getLineSeparator() {
        if (SystemUtils.isWindows()) {
            return "\r";
        }
        return GfshParser.LINE_SEPARATOR;
    }

    public CommandStringBuilder addOption(String option, String value) {
        this.buffer.append(" ");
        this.buffer.append(OPTION_MARKER);
        this.buffer.append(option);
        this.buffer.append(EQUAL_TO);
        this.buffer.append(value);
        this.hasOptions = true;
        return this;
    }

    public CommandStringBuilder addOption(String option, File value) {
        return this.addOption(option, this.quoteArgument(value.getAbsolutePath()));
    }

    public CommandStringBuilder addOptionWithValueCheck(String option, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return this.addOption(option, value);
        }
        return this;
    }

    public CommandStringBuilder addOption(String option) {
        this.buffer.append(" ");
        this.buffer.append(OPTION_MARKER);
        this.buffer.append(option);
        this.hasOptions = true;
        return this;
    }

    public CommandStringBuilder addNewLine() {
        this.buffer.append(" ");
        this.buffer.append(CommandStringBuilder.getLineSeparator());
        return this;
    }

    public String getCommandString() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.getCommandString();
    }

    private String quoteArgument(String argument) {
        if (!((String)argument).startsWith(DOUBLE_QUOTE)) {
            argument = DOUBLE_QUOTE + (String)argument;
        }
        if (!((String)argument).endsWith(DOUBLE_QUOTE)) {
            argument = (String)argument + DOUBLE_QUOTE;
        }
        return argument;
    }
}

