/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.GfshParser;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class GfshCompleter
implements Completer {
    private final GfshParser parser;

    public GfshCompleter(GfshParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("GfshParser cannot be null");
        }
        this.parser = parser;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (line == null) {
            return;
        }
        String commandLine = line.line();
        int cursor = line.cursor();
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.parser.completeAdvanced(commandLine, cursor, completions);
        for (Completion completion : completions) {
            Candidate candidate = new Candidate(completion.getValue(), completion.getValue(), null, null, null, null, true);
            candidates.add(candidate);
        }
    }
}

