/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.security;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class SecurePathResolver {
    private static final Set<String> SYSTEM_DIRECTORIES = new HashSet<String>();
    private static final Set<String> WINDOWS_SYSTEM_DIRECTORIES;
    private final Path baseDirectory;

    public SecurePathResolver(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Path resolveSecurePath(String userProvidedPath, boolean mustExist, boolean mustBeFile) throws SecurityException {
        Path canonicalPath;
        Path userPath;
        if (userProvidedPath == null || userProvidedPath.trim().isEmpty()) {
            throw new SecurityException("Path cannot be null or empty");
        }
        String normalizedInput = userProvidedPath.trim();
        if (normalizedInput.contains("..") || normalizedInput.contains("~")) {
            throw new SecurityException("Path traversal patterns detected: " + this.sanitizePath(normalizedInput));
        }
        try {
            userPath = Paths.get(normalizedInput, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new SecurityException("Invalid path syntax: " + this.sanitizePath(normalizedInput), e);
        }
        Path resolvedPath = this.baseDirectory != null ? this.baseDirectory.resolve(userPath).normalize() : userPath.toAbsolutePath().normalize();
        String normalizedStr = resolvedPath.normalize().toString();
        if (normalizedStr.contains("..")) {
            throw new SecurityException("Path traversal detected in normalized path: " + this.sanitizePath(normalizedInput));
        }
        String resolvedString = resolvedPath.toString();
        for (String sysDir : SYSTEM_DIRECTORIES) {
            if (!resolvedString.startsWith(sysDir)) continue;
            throw new SecurityException("Access to system directory denied: " + sysDir);
        }
        for (String winDir : WINDOWS_SYSTEM_DIRECTORIES) {
            if (!resolvedString.contains(winDir)) continue;
            throw new SecurityException("Access to system directory denied");
        }
        try {
            if (Files.exists(resolvedPath, new LinkOption[0])) {
                canonicalPath = resolvedPath.toRealPath(new LinkOption[0]);
            } else {
                if (mustExist) {
                    throw new SecurityException("Path does not exist: " + this.sanitizePath(normalizedInput));
                }
                canonicalPath = resolvedPath;
            }
        }
        catch (IOException e) {
            throw new SecurityException("Cannot resolve canonical path: " + this.sanitizePath(normalizedInput), e);
        }
        if (this.baseDirectory != null) {
            Path canonicalBase;
            try {
                canonicalBase = this.baseDirectory.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new SecurityException("Base directory not accessible", e);
            }
            if (!canonicalPath.startsWith(canonicalBase)) {
                throw new SecurityException("Path escapes base directory: " + this.sanitizePath(normalizedInput));
            }
        }
        if (mustExist) {
            if (!Files.exists(canonicalPath, new LinkOption[0])) {
                throw new SecurityException("File does not exist: " + this.sanitizePath(normalizedInput));
            }
            if (mustBeFile && !Files.isRegularFile(canonicalPath, new LinkOption[0])) {
                throw new SecurityException("Path does not point to a regular file: " + this.sanitizePath(normalizedInput));
            }
        }
        return canonicalPath;
    }

    private String sanitizePath(String path) {
        if (path == null) {
            return "<null>";
        }
        try {
            Path p = Paths.get(path, new String[0]);
            String filename = p.getFileName() != null ? p.getFileName().toString() : path;
            Object sanitized = filename.replaceAll("[<>:\"|?*]", "_");
            if (((String)sanitized).length() > 50) {
                sanitized = ((String)sanitized).substring(0, 47) + "...";
            }
            return sanitized;
        }
        catch (InvalidPathException e) {
            return "<invalid-path>";
        }
    }

    static {
        SYSTEM_DIRECTORIES.add("/etc");
        SYSTEM_DIRECTORIES.add("/sys");
        SYSTEM_DIRECTORIES.add("/proc");
        SYSTEM_DIRECTORIES.add("/dev");
        SYSTEM_DIRECTORIES.add("/boot");
        SYSTEM_DIRECTORIES.add("/root");
        WINDOWS_SYSTEM_DIRECTORIES = new HashSet<String>();
        WINDOWS_SYSTEM_DIRECTORIES.add(":\\Windows\\System32");
        WINDOWS_SYSTEM_DIRECTORIES.add(":\\Windows\\SysWOW64");
        WINDOWS_SYSTEM_DIRECTORIES.add(":\\Program Files\\");
        WINDOWS_SYSTEM_DIRECTORIES.add(":\\Program Files (x86)\\");
    }
}

