/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.result.Align;

class Column {
    private final Align align;
    private final String stringValue;

    Column(Object value, Align align) {
        this.stringValue = value == null ? "" : String.valueOf(value);
        this.align = align;
    }

    public String toString() {
        return "Column{align=" + String.valueOf((Object)this.align) + ", stringValue='" + this.stringValue + "'}";
    }

    int getLength() {
        return this.stringValue.length();
    }

    String buildColumn(int colWidth, boolean trimIt) {
        if (this.stringValue.length() > colWidth) {
            int endIndex = colWidth - 2;
            if (endIndex < 0) {
                return "";
            }
            return this.stringValue.substring(0, endIndex) + "..";
        }
        int numSpaces = colWidth - this.stringValue.length();
        if (trimIt) {
            numSpaces = 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.align) {
            case LEFT: {
                stringBuilder.append(this.stringValue).append(Column.spaces(numSpaces));
                break;
            }
            case RIGHT: {
                stringBuilder.append(Column.spaces(numSpaces)).append(this.stringValue);
                break;
            }
            case CENTER: {
                stringBuilder.append(Column.spaces(numSpaces / 2)).append(this.stringValue).append(Column.spaces(numSpaces - numSpaces / 2));
            }
        }
        return stringBuilder.toString();
    }

    private static String spaces(int count) {
        return StringUtils.repeat((char)' ', (int)count);
    }
}

