/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class FilePathStringConverter
implements Converter<String, String> {
    public String convert(@NonNull String source) {
        return source;
    }

    public List<String> getRoots() {
        File[] roots = File.listRoots();
        return Arrays.stream(roots).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public List<String> getSiblings(String path) {
        File currentFile = new File(path);
        if (!currentFile.isDirectory()) {
            if ((currentFile = currentFile.getParentFile()) == null) {
                currentFile = new File("./");
                path = null;
            } else {
                path = currentFile.getPath();
            }
        }
        Object prefix = path == null ? "" : (path.endsWith(File.separator) ? path : path + File.separator);
        return Stream.of(currentFile).map(File::list).filter(Objects::nonNull).flatMap(Stream::of).map(arg_0 -> FilePathStringConverter.lambda$getSiblings$0((String)prefix, arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$getSiblings$0(String prefix, String s) {
        return prefix + s;
    }
}

