/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ConfigPropertyConverter
implements Converter<String, JndiBindingsType.JndiBinding.ConfigProperty[]> {
    private static final Pattern OBJECT_PATTERN = Pattern.compile("\\{([^}]*)\\}");
    private static final Pattern NAME_PATTERN = Pattern.compile("'name'\\s*:\\s*'([^']*)'");
    private static final Pattern TYPE_PATTERN = Pattern.compile("'type'\\s*:\\s*'([^']*)'");
    private static final Pattern VALUE_PATTERN = Pattern.compile("'value'\\s*:\\s*'([^']*)'");

    public JndiBindingsType.JndiBinding.ConfigProperty[] convert(@NonNull String source) {
        if (source == null || source.trim().isEmpty()) {
            return new JndiBindingsType.JndiBinding.ConfigProperty[0];
        }
        ArrayList<JndiBindingsType.JndiBinding.ConfigProperty> properties = new ArrayList<JndiBindingsType.JndiBinding.ConfigProperty>();
        Matcher objectMatcher = OBJECT_PATTERN.matcher(source);
        while (objectMatcher.find()) {
            String objectContent = objectMatcher.group(1);
            String name = this.extractField(NAME_PATTERN, objectContent);
            String type = this.extractField(TYPE_PATTERN, objectContent);
            String value = this.extractField(VALUE_PATTERN, objectContent);
            if (name == null || value == null) {
                throw new IllegalArgumentException("Invalid config property format. Required fields: 'name', 'value'. Optional field: 'type'. Got: {" + objectContent + "}");
            }
            JndiBindingsType.JndiBinding.ConfigProperty property = type != null ? new JndiBindingsType.JndiBinding.ConfigProperty(name, type, value) : new JndiBindingsType.JndiBinding.ConfigProperty(name, value);
            properties.add(property);
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("Invalid datasource-config-properties format. Expected: {'name':'name1','type':'type1','value':'value1'},{'name':'name2','type':'type2','value':'value2'}. Got: " + source);
        }
        return properties.toArray(new JndiBindingsType.JndiBinding.ConfigProperty[0]);
    }

    private String extractField(Pattern pattern, String source) {
        Matcher matcher = pattern.matcher(source);
        return matcher.find() ? matcher.group(1) : null;
    }
}

