/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;

public class IndexTypeCompletionProvider
implements ValueCompletionProvider {
    @Override
    public boolean supports(Class<?> targetType) {
        return targetType != null && targetType.equals(IndexType.class);
    }

    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String lowerPartial = partialValue.toLowerCase();
        ArrayList<String> synonyms = new ArrayList<String>();
        for (IndexType indexType : IndexType.values()) {
            String synonym = indexType.getName().toLowerCase();
            if (!lowerPartial.isEmpty() && !synonym.startsWith(lowerPartial)) continue;
            synonyms.add(synonym);
        }
        synonyms.sort(String::compareTo);
        for (String synonym : synonyms) {
            completions.add(new Completion(synonym));
        }
        return completions;
    }
}

