/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;

public class BooleanCompletionProvider
implements ValueCompletionProvider {
    private static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};

    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String lowerPartial = partialValue.toLowerCase();
        for (String value : BOOLEAN_VALUES) {
            if (!lowerPartial.isEmpty() && !value.startsWith(lowerPartial)) continue;
            completions.add(new Completion(value));
        }
        return completions;
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return targetType == Boolean.class || targetType == Boolean.TYPE;
    }
}

