/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class UsernamePasswordInterceptor
extends AbstractCliAroundInterceptor {
    private final Gfsh gfsh;

    public UsernamePasswordInterceptor() {
        this(Gfsh.getCurrentInstance());
    }

    public UsernamePasswordInterceptor(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        if (this.gfsh == null || !this.gfsh.isConnectedAndReady()) {
            return new ResultModel();
        }
        Object userInput = parseResult.getUserInput();
        String username = parseResult.getParamValueAsString("username");
        String password = parseResult.getParamValueAsString("password");
        if (!StringUtils.isBlank((CharSequence)password) && StringUtils.isBlank((CharSequence)username)) {
            username = this.gfsh.readText("Username: ");
            userInput = (String)userInput + " --username=" + username;
            parseResult.setUserInput((String)userInput);
        } else if (!StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
            password = this.gfsh.readPassword("Password: ");
            userInput = (String)userInput + " --password=" + password;
            parseResult.setUserInput((String)userInput);
        }
        return new ResultModel();
    }
}

