/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.UndeployFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class UndeployCommand
extends GfshCommand {
    private final UndeployFunction undeployFunction = new UndeployFunction();

    @ShellMethod(value="Undeploy JARs from a member or members.", key={"undeploy"})
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel undeploy(@ShellOption(value={"group", "groups"}, help="Group(s) of members from which to undeploy JARs. If not specified, undeploy will occur on all members.") String[] groups, @ShellOption(value={"jar", "jars"}, help="JAR(s) to be undeployed.  If not specified, all JARs will be undeployed.") String[] jars) {
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)this.undeployFunction, new Object[]{jars}, targetMembers);
        ResultModel result = new ResultModel();
        TabularResultModel tabularData = result.addTable("jars");
        for (CliFunctionResult cliResult : results) {
            Map undeployedJars;
            if (!cliResult.isSuccessful()) {
                result.setStatus(Result.Status.ERROR);
            }
            if ((undeployedJars = (Map)cliResult.getResultObject()) == null) continue;
            for (String key : undeployedJars.keySet()) {
                tabularData.accumulate("Member", cliResult.getMemberIdOrName());
                tabularData.accumulate("Un-Deployed JAR", key);
                tabularData.accumulate("Un-Deployed From JAR Location", (String)undeployedJars.get(key));
            }
        }
        if (tabularData.getRowSize() == 0) {
            return ResultModel.createInfo("No JAR Files Found");
        }
        if (result.getStatus() != Result.Status.OK) {
            return result;
        }
        if (this.getConfigurationPersistenceService() == null) {
            result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
        } else {
            ((InternalConfigurationPersistenceService)this.getConfigurationPersistenceService()).removeJars(jars, groups);
        }
        return result;
    }

    @Override
    public boolean affectsClusterConfiguration() {
        return true;
    }
}

