/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ResumeGatewaySenderCommand
extends GfshCommand {
    @ShellMethod(value="Resume the Gateway Sender on a member or members.", key={"resume gateway-sender"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel resumeGatewaySender(@ShellOption(value={"id"}, help="ID of the Gateway Sender.") String senderId, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which to resume the Gateway Sender.") String[] onGroup, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to resume the Gateway Sender.") String[] onMember) {
        if (senderId != null) {
            senderId = senderId.trim();
        }
        Cache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultData = resultModel.addTable("resume gateway-sender");
        for (DistributedMember member : dsMembers) {
            GatewaySenderMXBean bean;
            if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                bean = service.getLocalGatewaySenderMXBean(senderId);
            } else {
                ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                bean = (GatewaySenderMXBean)service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
            }
            if (bean != null) {
                if (bean.isRunning()) {
                    if (bean.isPaused()) {
                        bean.resume();
                        resultData.addMemberStatusResultRow(member.getId(), "OK", CliStrings.format((String)"GatewaySender {0} is resumed on member {1}", (Object[])new Object[]{senderId, member.getId()}));
                        continue;
                    }
                    resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewaySender {0} is not paused on member {1}", (Object[])new Object[]{senderId, member.getId()}));
                    continue;
                }
                resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewaySender {0} is not running on member {1}.", (Object[])new Object[]{senderId, member.getId()}));
                continue;
            }
            resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewaySender {0} is not available on member {1}", (Object[])new Object[]{senderId, member.getId()}));
        }
        return resultModel;
    }
}

