/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.i18n.CliStrings;

public abstract class OfflineGfshCommand {
    public boolean isDebugging() {
        return this.getGfsh() != null && this.getGfsh().getDebug();
    }

    public boolean isLogging() {
        return this.getGfsh() != null;
    }

    public Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    public JMXServiceURL getJmxServiceUrl() {
        OperationInvoker operationInvoker = this.getGfsh().getOperationInvoker();
        if (operationInvoker instanceof JmxOperationInvoker) {
            return ((JmxOperationInvoker)operationInvoker).getJmxServiceUrl();
        }
        return null;
    }

    public boolean isConnectedAndReady() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh != null && gfsh.isConnectedAndReady();
    }

    protected Properties loadProperties(File ... files) {
        Properties properties = new Properties();
        if (files == null) {
            return properties;
        }
        for (File file : files) {
            if (file == null) continue;
            properties.putAll((Map<?, ?>)this.loadPropertiesFromFile(file));
        }
        return properties;
    }

    private Properties loadPropertiesFromFile(File propertyFile) {
        try {
            return OfflineGfshCommand.loadPropertiesFromUrl(propertyFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(CliStrings.format((String)"Failed to load configuration properties from pathname (%1$s)!", (Object)propertyFile.getAbsolutePath()), e);
        }
    }

    private static Properties loadPropertiesFromUrl(URL url) {
        Properties properties = new Properties();
        if (url == null) {
            return properties;
        }
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException io) {
            throw new RuntimeException(CliStrings.format((String)"Could not read config from {0}.", (Object)CliUtils.decodeWithDefaultCharSet(url.getPath())), io);
        }
        return properties;
    }
}

