/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ImportDataFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ImportDataCommand
extends GfshCommand {
    private final ImportDataFunction importDataFunction = new ImportDataFunction();

    @ShellMethod(value="Import user data from a file to a region.", key={"import data"})
    @CliMetaData(relatedTopic={"Data", "Region"})
    public ResultModel importData(@ShellOption(value={"member"}, help="Name/Id of a member which hosts the region. The data will be imported from the specified file on the host where the member is running.") String memberNameOrId, @ShellOption(value={"region"}, help="Region into which data will be imported.") String regionName, @ShellOption(value={"file"}, defaultValue="__NULL__", help="File from which the imported data will be read. The file must have an extension of \".gfd\". Cannot be specified at the same time as \"dir\"") String filePath, @ShellOption(value={"dir"}, defaultValue="__NULL__", help="Directory from which all data files (\".gfd\") will be read. Required if parallel set to true. Cannot be specified at the same time as \"file\"") String dirPath, @ShellOption(value={"invoke-callbacks"}, defaultValue="false", help="Whether callbacks should be invoked") boolean invokeCallbacks, @ShellOption(value={"parallel"}, defaultValue="false", help="Import data from given directory on all members. Used to import data from a parallel export. Available for partitioned regions only") boolean parallel) {
        ResultModel result;
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        DistributedMember targetMember = this.getMember(memberNameOrId);
        Optional<ResultModel> validationResult = this.validatePath(filePath, dirPath, parallel);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            String path = dirPath != null ? dirPath : filePath;
            Object[] args = new Object[]{regionName, path, invokeCallbacks, parallel};
            ResultCollector<?, ?> rc = this.executeFunction((Function<?>)this.importDataFunction, (Object)args, targetMember);
            List results = (List)rc.getResult();
            result = ResultModel.createMemberStatusResult(results);
        }
        catch (CacheClosedException e) {
            result = ResultModel.createError(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultModel.createError(CliStrings.format((String)"Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    private Optional<ResultModel> validatePath(String filePath, String dirPath, boolean parallel) {
        if (filePath == null && dirPath == null) {
            return Optional.of(ResultModel.createError("Must specify a location to load snapshot from"));
        }
        if (filePath != null && dirPath != null) {
            return Optional.of(ResultModel.createError("Options \"file\" and \"dir\" cannot be specified at the same time"));
        }
        if (parallel && dirPath == null) {
            return Optional.of(ResultModel.createError("Must specify a directory to load snapshot files from"));
        }
        if (dirPath == null && !filePath.endsWith(".gfd")) {
            return Optional.of(ResultModel.createError(CliStrings.format((String)"Invalid file type, the file extension must be \"{0}\"", (Object)".gfd")));
        }
        return Optional.empty();
    }
}

