/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ExportOfflineDiskStoreCommand
extends GfshCommand {
    @ShellMethod(value="Export region data from an offline disk store into Geode snapshot files.", key={"export offline-disk-store"})
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel exportOfflineDiskStore(@ShellOption(value={"name"}, help="Name of the disk store to be exported.") String diskStoreName, @ShellOption(value={"disk-dirs"}, help="Directories which contain the disk store files.") String[] diskDirs, @ShellOption(value={"dir"}, help="Directory to export snapshot files to.") String dir) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            File output = new File(dir);
            DiskStoreImpl.exportOfflineSnapshot((String)diskStoreName, (File[])dirs, (File)output);
            return ResultModel.createInfo(CliStrings.format((String)"Exported all regions from disk store {0} to the directory {1}", (Object[])new Object[]{diskStoreName, dir}));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            LogWrapper.getInstance(this.getCache()).warning(th.getMessage(), th);
            return ResultModel.createError(CliStrings.format((String)"Error exporting disk store {0} is : {1}", (Object[])new Object[]{diskStoreName, th.toString()}));
        }
    }
}

