/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DestroyDiskStoreCommand
extends SingleGfshCommand {
    @ShellMethod(value="Destroy a disk store, including deleting all files on disk used by the disk store. Data for closed regions previously using the disk store will be lost.", key={"destroy disk-store"})
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public ResultModel destroyDiskStore(@ShellOption(value={"name"}, help="Name of the disk store that will be destroyed.") String name, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which the disk store will be destroyed. If no group is specified the disk store will be destroyed on all members.") String[] groups, @ShellOption(value={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", defaultValue="false") boolean ifExist) {
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        DestroyDiskStoreFunctionArgs functionArgs = new DestroyDiskStoreFunctionArgs(name, ifExist);
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)new DestroyDiskStoreFunction(), functionArgs, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(results, ifExist);
        result.setConfigObject(name);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        String diskStoreName = (String)configObject;
        Identifiable.remove((List)config.getDiskStores(), (String)diskStoreName);
        return true;
    }
}

