/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;

@ShellComponent
public class DescribeConnectionCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Display information about the current connection.", key={"describe connection"})
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX"})
    public ResultModel describeConnection() {
        ResultModel result = new ResultModel();
        TabularResultModel table = result.addTable("endPoints");
        table.setColumnHeader("Connection Endpoints");
        Gfsh gfshInstance = this.getGfsh();
        if (gfshInstance.isConnectedAndReady()) {
            OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
            table.addRow(operationInvoker.toString());
        } else {
            table.addRow("Not connected");
        }
        return result;
    }
}

