/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.GetSubscriptionQueueSizeFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CountDurableCQEventsCommand
extends GfshCommand {
    @ShellMethod(value="Shows the number of events in the subscription queue.  If a cq name is provided, counts the number of events in the subscription queue for the specified cq.", key={"show subscription-queue-size"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel countDurableCqEvents(@ShellOption(value={"durable-client-id"}, help="The id used to identify the durable client.") String durableClientId, @ShellOption(value={"durable-cq-name"}, help="The name that identifies the cq.") String cqName, @ShellOption(value={"member", "members"}, help="Name/Id of the member for which the subscription events are to be counted.") String[] memberNameOrId, @ShellOption(value={"group", "groups"}, help="Group of members for which the subscription queue events are to be counted.") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        String[] params = new String[]{durableClientId, cqName};
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)new GetSubscriptionQueueSizeFunction(), (Object)params, targetMembers);
        List funcResults = (List)rc.getResult();
        ResultModel result = new ResultModel();
        TabularResultModel table = result.addTable("subscription-queue-size");
        for (CliFunctionResult oneResult : funcResults) {
            table.accumulate("Member", oneResult.getMemberIdOrName());
            table.accumulate("Status", oneResult.getStatus());
            table.accumulate("Queue Size", oneResult.getStatusMessage());
            if (oneResult.isSuccessful()) continue;
            result.setStatus(Result.Status.ERROR);
        }
        return result;
    }
}

