/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.DiskStoreCompacter;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CompactOfflineDiskStoreCommand
extends GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ShellMethod(value="Compact an offline disk store. If the disk store is large, additional memory may need to be allocated to the process using the --J=-Xmx??? parameter.", key={"compact offline-disk-store"})
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel compactOfflineDiskStore(@ShellOption(value={"name"}, help="Name of the offline disk store to be compacted.") String diskStoreName, @ShellOption(value={"disk-dirs"}, help="Directories where data for the disk store was previously written.") String[] diskDirs, @ShellOption(value={"max-oplog-size"}, defaultValue="-1", help="Maximum size (in megabytes) of the oplogs created by compaction.") long maxOplogSize, @ShellOption(value={"J"}, help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") String[] jvmProps) {
        String validatedDirectories = DiskStoreCommandsUtils.validatedDirectories(diskDirs);
        if (validatedDirectories != null) {
            throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
        }
        ResultModel result = new ResultModel();
        InfoResultModel infoResult = result.addInfo();
        LogWrapper logWrapper = LogWrapper.getInstance(this.getCache());
        Process compactorProcess = null;
        try {
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            DiskStoreCommandsUtils.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                commandList.addAll(Arrays.asList(jvmProps));
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreCompacter.class.getName());
            commandList.add("name=" + diskStoreName);
            if (diskDirs.length != 0) {
                StringBuilder builder = new StringBuilder();
                int arrayLength = diskDirs.length;
                for (int i = 0; i < arrayLength; ++i) {
                    if (File.separatorChar == '\\') {
                        builder.append(diskDirs[i].replace("\\", "/"));
                    } else {
                        builder.append(diskDirs[i]);
                    }
                    if (i + 1 == arrayLength) continue;
                    builder.append(',');
                }
                commandList.add("disk-dirs=" + String.valueOf(builder));
            }
            commandList.add("max-oplog-size=" + maxOplogSize);
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            procBuilder.redirectErrorStream(true);
            compactorProcess = procBuilder.start();
            try (InputStream inputStream = compactorProcess.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader inputReader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = inputReader.readLine()) != null) {
                    infoResult.addLine(line);
                }
            }
            compactorProcess.waitFor(2L, TimeUnit.SECONDS);
            if (compactorProcess.exitValue() != 0) {
                result.setStatus(Result.Status.ERROR);
            }
        }
        catch (Exception e) {
            infoResult.addLine(String.format("Error compacting disk store %s: %s", diskStoreName, e.getMessage()));
            result.setStatus(Result.Status.ERROR);
            logWrapper.warning(e.getMessage(), e);
        }
        finally {
            if (compactorProcess != null) {
                try {
                    compactorProcess.exitValue();
                }
                catch (IllegalThreadStateException ise) {
                    compactorProcess.destroy();
                }
            }
        }
        return result;
    }
}

