/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class GfshParseResult {
    private String userInput;
    private final String commandName;
    private final Map<String, Object> paramValueMap = new HashMap<String, Object>();
    private final Method method;
    private final Object instance;
    private final Object[] arguments;

    protected GfshParseResult(Method method, Object instance, Object[] arguments, String userInput) {
        this.method = method;
        this.instance = instance;
        this.arguments = arguments;
        this.userInput = userInput.trim();
        ShellMethod shellMethod = method.getAnnotation(ShellMethod.class);
        this.commandName = shellMethod != null && shellMethod.key().length > 0 ? shellMethod.key()[0] : method.getName();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (arguments == null) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            String optionName;
            Object argument = arguments[i];
            ShellOption option = this.getOption(parameterAnnotations, i);
            if (option == null) continue;
            String string = optionName = option.value().length > 0 ? option.value()[0] : null;
            if (optionName != null) {
                this.paramValueMap.put(optionName, argument);
            }
            if (argument == null) continue;
            if (argument instanceof Object[]) {
                String argumentAsString = StringUtils.join((Object[])((Object[])argument), (String)",");
                continue;
            }
            String string2 = argument.toString();
        }
    }

    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userText) {
        this.userInput = userText;
    }

    public Object getParamValue(String param) {
        return this.paramValueMap.get(param);
    }

    public String getParamValueAsString(String param) {
        Object argument = this.paramValueMap.get(param);
        if (argument == null) {
            return null;
        }
        String argumentAsString = argument instanceof Object[] ? StringUtils.join((Object[])((Object[])argument), (String)",") : argument.toString();
        return argumentAsString;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    private ShellOption getOption(Annotation[][] parameterAnnotations, int index) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = parameterAnnotations[index]) {
            if (!(annotation instanceof ShellOption)) continue;
            return (ShellOption)annotation;
        }
        return null;
    }

    public String toString() {
        return this.userInput;
    }
}

