/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geode.management.internal.cli.domain.DeploymentInfo;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class DeploymentInfoTableUtil {
    public static List<DeploymentInfo> getDeploymentInfoFromFunctionResults(List<CliFunctionResult> functionResults) {
        LinkedList<DeploymentInfo> deployedJarInfo = new LinkedList<DeploymentInfo>();
        for (CliFunctionResult cliResult : functionResults) {
            if (cliResult.getResultObject() instanceof Map) {
                Map infoMap = (Map)cliResult.getResultObject();
                if (infoMap == null) continue;
                for (Map.Entry deploymentInfoEntry : infoMap.entrySet()) {
                    deployedJarInfo.add(new DeploymentInfo(cliResult.getMemberIdOrName(), (String)deploymentInfoEntry.getKey(), (String)deploymentInfoEntry.getValue()));
                }
                continue;
            }
            if (!(cliResult.getResultObject() instanceof List)) continue;
            deployedJarInfo.addAll((List)cliResult.getResultObject());
        }
        return deployedJarInfo;
    }

    public static void writeDeploymentInfoToTable(String[] columnHeaders, TabularResultModel tabularData, List<DeploymentInfo> deployedJarInfo) {
        for (DeploymentInfo deploymentInfo : deployedJarInfo) {
            tabularData.accumulate(columnHeaders[0], deploymentInfo.getMemberName());
            tabularData.accumulate(columnHeaders[1], deploymentInfo.getFileName());
            tabularData.accumulate(columnHeaders[2], deploymentInfo.getAdditionalDeploymentInfo());
        }
    }
}

