/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.jline.GfshHistory;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class HistoryCommand
extends OfflineGfshCommand {
    @CliCommand(value={"history"}, help="Display or export previously executed GFSH commands.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel history(@CliOption(key={"file"}, help="File to which the history will be written.") String saveHistoryTo, @CliOption(key={"clear"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Clears the history of GFSH commands. Takes value as true or false") Boolean clearHistory) throws IOException {
        if (clearHistory.booleanValue()) {
            return this.executeClearHistory();
        }
        Gfsh gfsh = this.getGfsh();
        boolean hasFile = StringUtils.isNotBlank((CharSequence)saveHistoryTo);
        File saveHistoryToFile = null;
        if (hasFile) {
            saveHistoryToFile = new File(saveHistoryTo);
            if (saveHistoryToFile.exists()) {
                return ResultModel.createError("File exists already");
            }
            if (saveHistoryToFile.isDirectory()) {
                return ResultModel.createError("File Should not be a directory");
            }
        }
        GfshHistory gfshHistory = gfsh.getGfshHistory();
        ListIterator it = gfshHistory.entries();
        ResultModel result = new ResultModel();
        InfoResultModel histories = result.addInfo("history");
        while (it.hasNext()) {
            String line = it.next().toString();
            if (line.isEmpty()) continue;
            if (hasFile) {
                FileUtils.writeStringToFile((File)saveHistoryToFile, (String)(line + GfshParser.LINE_SEPARATOR), (String)"UTF-8", (boolean)true);
                continue;
            }
            histories.addLine(line);
        }
        if (hasFile) {
            return ResultModel.createInfo("Wrote successfully to file " + saveHistoryTo);
        }
        return result;
    }

    private ResultModel executeClearHistory() {
        this.getGfsh().clearHistory();
        return ResultModel.createInfo("Successfully deleted history");
    }
}

