/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.operation.RebalanceOperationPerformer;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.operation.RebalanceOperation;
import org.apache.geode.management.runtime.RebalanceRegionResult;
import org.apache.geode.management.runtime.RebalanceResult;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RebalanceCommand
extends GfshCommand {
    @CliCommand(value={"rebalance"}, help="Rebalance partitioned regions. The default is for all partitioned regions to be rebalanced.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel rebalance(@CliOption(key={"include-region"}, help="Partitioned regions to be included when rebalancing. Includes take precedence over excludes.") String[] includeRegions, @CliOption(key={"exclude-region"}, help="Partitioned regions to be excluded when rebalancing.") String[] excludeRegions, @CliOption(key={"time-out"}, unspecifiedDefaultValue="-1", help="Time to wait (in seconds) before GFSH returns to a prompt while rebalancing continues in the background. The default is to wait for rebalancing to complete.") long timeout, @CliOption(key={"simulate"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to only simulate rebalancing. The --time-out parameter is not available when simulating.") boolean simulate) {
        ResultModel result;
        ExecutorService commandExecutors = LoggingExecutors.newSingleThreadExecutor((String)"RebalanceCommand", (boolean)true);
        ArrayList<Future<ResultModel>> commandResult = new ArrayList<Future<ResultModel>>();
        try {
            commandResult.add(commandExecutors.submit(this.rebalanceCallable(includeRegions, excludeRegions, simulate)));
            Future fs = (Future)commandResult.get(0);
            result = timeout > 0L ? (ResultModel)fs.get(timeout, TimeUnit.SECONDS) : (ResultModel)fs.get();
        }
        catch (TimeoutException timeoutException) {
            result = ResultModel.createInfo("Rebalance will continue in background");
        }
        catch (Exception ex) {
            result = ResultModel.createError(ex.getMessage());
        }
        return result;
    }

    public Callable<ResultModel> rebalanceCallable(String[] includeRegions, String[] excludeRegions, boolean simulate) {
        return new ExecuteRebalanceWithTimeout(includeRegions, excludeRegions, simulate, (InternalCache)this.getCache());
    }

    private void toCompositeResultData(ResultModel result, RebalanceRegionResult results, int index, boolean simulate, InternalCache cache) {
        ArrayList<String> rsltList = new ArrayList<String>();
        rsltList.add(0, String.valueOf(results.getBucketCreateBytes()));
        rsltList.add(1, String.valueOf(results.getBucketCreateTimeInMilliseconds()));
        rsltList.add(2, String.valueOf(results.getBucketCreatesCompleted()));
        rsltList.add(3, String.valueOf(results.getBucketTransferBytes()));
        rsltList.add(4, String.valueOf(results.getBucketTransferTimeInMilliseconds()));
        rsltList.add(5, String.valueOf(results.getBucketTransfersCompleted()));
        rsltList.add(6, String.valueOf(results.getPrimaryTransferTimeInMilliseconds()));
        rsltList.add(7, String.valueOf(results.getPrimaryTransfersCompleted()));
        rsltList.add(8, String.valueOf(results.getTimeInMilliseconds()));
        rsltList.add(9, String.valueOf(results.getNumOfMembers()));
        String regionName = results.getRegionName();
        if (!regionName.startsWith("/")) {
            regionName = "/" + regionName;
        }
        rsltList.add(10, regionName);
        this.toCompositeResultData(result, rsltList, index, simulate, cache);
    }

    private void toCompositeResultData(ResultModel result, List<String> rstlist, int index, boolean simulate, InternalCache cache) {
        int resultItemCount = 10;
        if (rstlist.size() <= 10 || StringUtils.isEmpty((CharSequence)rstlist.get(10))) {
            return;
        }
        TabularResultModel table1 = result.addTable("Table" + index);
        String newLine = System.getProperty("line.separator");
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(newLine);
        table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
        table1.accumulate("Value", rstlist.get(0));
        resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(rstlist.get(0)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
        table1.accumulate("Value", rstlist.get(1));
        resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(rstlist.get(1)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
        table1.accumulate("Value", rstlist.get(2));
        resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(rstlist.get(2)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
        table1.accumulate("Value", rstlist.get(3));
        resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(rstlist.get(3)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
        table1.accumulate("Value", rstlist.get(4));
        resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(rstlist.get(4)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
        table1.accumulate("Value", rstlist.get(5));
        resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(rstlist.get(5)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
        table1.accumulate("Value", rstlist.get(6));
        resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(rstlist.get(6)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
        table1.accumulate("Value", rstlist.get(7));
        resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(rstlist.get(7)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
        table1.accumulate("Value", rstlist.get(8));
        resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(rstlist.get(8)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total number of members in system on which rebalance is executed");
        table1.accumulate("Value", rstlist.get(9));
        resultStr.append("Total number of members in system on which rebalance is executed").append(" = ").append(rstlist.get(9)).append(newLine);
        String headerText = simulate ? "Simulated partition regions" : "Rebalanced partition regions";
        for (int i = 10; i < rstlist.size(); ++i) {
            headerText = headerText + " " + rstlist.get(i);
        }
        table1.setHeader(headerText);
        cache.getLogger().info(headerText + resultStr);
    }

    private class ExecuteRebalanceWithTimeout
    implements Callable<ResultModel> {
        boolean simulate;
        InternalCache cache;
        String[] includeRegions;
        String[] excludeRegions;

        @Override
        public ResultModel call() throws Exception {
            ResultModel result = this.executeRebalanceWithTimeout(this.includeRegions, this.excludeRegions, this.simulate);
            if (result.getSectionSize() == 1 && result.getInfoSection("error") != null) {
                result.setStatus(Result.Status.ERROR);
            }
            return result;
        }

        ExecuteRebalanceWithTimeout(String[] includedRegions, String[] excludedRegions, boolean toSimulate, InternalCache cache) {
            this.includeRegions = includedRegions;
            this.excludeRegions = excludedRegions;
            this.simulate = toSimulate;
            this.cache = cache;
        }

        private ResultModel executeRebalanceWithTimeout(String[] includeRegions, String[] excludeRegions, boolean simulate) {
            ResultModel result = new ResultModel();
            RebalanceOperation operation = new RebalanceOperation();
            if (includeRegions != null) {
                operation.setIncludeRegions(Arrays.asList(includeRegions));
            }
            if (excludeRegions != null) {
                operation.setExcludeRegions(Arrays.asList(excludeRegions));
            }
            operation.setSimulate(simulate);
            RebalanceResult rebalanceResult = new RebalanceOperationPerformer().perform((Cache)this.cache, operation);
            if (!rebalanceResult.getSuccess()) {
                result.addInfo("error");
            }
            int index = 0;
            for (RebalanceRegionResult rebalanceRegionResult : rebalanceResult.getRebalanceRegionResults()) {
                RebalanceCommand.this.toCompositeResultData(result, rebalanceRegionResult, index, simulate, this.cache);
                ++index;
            }
            return result;
        }
    }
}

