/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ListDeployedFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ListDeployedFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            InternalCache cache = (InternalCache)context.getCache();
            JarDeployer jarDeployer = ClassPathLoader.getLatest().getJarDeployer();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            List jarClassLoaders = jarDeployer.findDeployedJars();
            HashMap<String, String> jars = new HashMap<String, String>();
            for (DeployedJar jarClassLoader : jarClassLoaders) {
                jars.put(jarClassLoader.getDeployedFileName(), jarClassLoader.getFileCanonicalPath());
            }
            CliFunctionResult result = new CliFunctionResult(memberId, jars, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (Exception cce) {
            logger.error(cce.getMessage(), (Throwable)cce);
            CliFunctionResult result = new CliFunctionResult(memberId, false, cce.getMessage());
            context.getResultSender().lastResult((Object)result);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

