/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class ListDurableCqNamesFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    public String getId() {
        return ListDurableCqNamesFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        Cache cache = context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = CliUtil.getMemberNameOrId(member);
        String durableClientId = (String)context.getArguments();
        context.getResultSender().lastResult(this.createFunctionResult(memberNameOrId, durableClientId));
    }

    private List<CliFunctionResult> createFunctionResult(String memberNameOrId, String durableClientId) {
        ArrayList<CliFunctionResult> results = new ArrayList<CliFunctionResult>();
        try {
            CacheClientNotifier ccn = CacheClientNotifier.getInstance();
            if (ccn == null) {
                results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.IGNORABLE, "No client found on this server"));
                return results;
            }
            CacheClientProxy ccp = ccn.getClientProxy(durableClientId);
            if (ccp == null) {
                results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.IGNORABLE, CliStrings.format((String)"No client found with client-id : {0}", (Object)durableClientId)));
                return results;
            }
            CqService cqService = ccp.getCache().getCqService();
            if (cqService == null || !cqService.isRunning()) {
                results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.IGNORABLE, "No durable cqs registered on this member."));
                return results;
            }
            List durableCqNames = cqService.getAllDurableClientCqs(ccp.getProxyID());
            if (durableCqNames == null || durableCqNames.isEmpty()) {
                results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.IGNORABLE, CliStrings.format((String)"No durable cqs found for durable-client-id : \"{0}\".", (Object)durableClientId)));
                return results;
            }
            for (String cqName : durableCqNames) {
                results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, cqName));
            }
            return results;
        }
        catch (Exception e) {
            results.add(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, e.getMessage()));
            return results;
        }
    }
}

